/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.views.BasePropertySection;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.linuxtools.internal.docker.ui.views.ImageInspectContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ImageInspectPropertySection
extends BasePropertySection {
    private static final String PropertiesInfoError = "PropertiesInfoError.msg";
    private static final String PropertiesLoadingImageInfo = "PropertiesLoadingImageInfo.msg";
    private IDockerImage selectedImage;
    private Object imageInfo;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.getTreeViewer().setContentProvider((IContentProvider)new ImageInspectContentProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object input = null;
        if (selection instanceof ITreeSelection) {
            input = ((ITreeSelection)selection).getFirstElement();
        } else if (selection instanceof IStructuredSelection) {
            input = ((IStructuredSelection)selection).getFirstElement();
        }
        Assert.isTrue((boolean)(input instanceof IDockerImage));
        this.selectedImage = (IDockerImage)input;
        IDockerConnection parentConnection = part instanceof DockerImagesView ? ((DockerImagesView)part).getConnection() : (IDockerConnection)((ITreeSelection)selection).getPathsFor((Object)this.selectedImage)[0].getFirstSegment();
        this.imageInfo = this.getImageInfo(parentConnection, this.selectedImage);
        if (this.getTreeViewer() != null && this.imageInfo != null) {
            this.getTreeViewer().setInput(this.imageInfo);
            this.getTreeViewer().expandAll();
        }
    }

    private IDockerImageInfo getImageInfo(final IDockerConnection connection, final IDockerImage image) {
        final ArrayBlockingQueue result = new ArrayBlockingQueue(1);
        Job loadConnectionInfoJob = new Job(DVMessages.getString(PropertiesLoadingImageInfo)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(ImageInspectPropertySection.PropertiesLoadingImageInfo), 1);
                result.add(connection.getImageInfo(image.id()));
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        loadConnectionInfoJob.schedule();
        try {
            return (IDockerImageInfo)result.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", DVMessages.getFormattedString(PropertiesInfoError, connection.getName()), (Throwable)e));
            return null;
        }
    }
}

