/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.views.ImageViewLabelAndContentProvider;

public class ImageComparator
extends ViewerComparator {
    private static final int UP = 1;
    private int column;
    private int direction;

    public ImageComparator(int column) {
        this.column = column;
        this.direction = 1;
    }

    public void setColumn(int newColumn) {
        if (this.column != newColumn) {
            this.direction = 1;
        }
        this.column = newColumn;
    }

    public int getColumn() {
        return this.column;
    }

    public void reverseDirection() {
        this.direction *= -1;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof IDockerImage) || !(e2 instanceof IDockerImage)) {
            return 0;
        }
        int tmp = this.compareByColumn(viewer, (IDockerImage)e1, (IDockerImage)e2);
        return tmp * this.direction;
    }

    private int compareByColumn(Viewer viewer, IDockerImage e1, IDockerImage e2) {
        ImageViewLabelAndContentProvider provider = (ImageViewLabelAndContentProvider)((TableViewer)viewer).getContentProvider();
        Object s1 = provider.getColumnCompareObject(e1, this.column);
        Object s2 = provider.getColumnCompareObject(e2, this.column);
        if (s1 instanceof String) {
            return ((String)s1).compareToIgnoreCase((String)s2);
        }
        if (s1 instanceof Long) {
            return ((Long)s1).compareTo((Long)s2);
        }
        return 0;
    }
}

