/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImageBuildFailedException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.ProgressJob;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class ImageBuildProgressHandler
implements IDockerProgressHandler {
    private static final String IMAGE_BUILD_COMPLETE = "ImageBuildComplete.msg";
    private static final String IMAGE_BUILDING_JOBNAME = "ImageBuildingJobName.msg";
    private static final String IMAGE_BUILDING = "ImageBuilding.msg";
    private static final String IMAGE_BUILD_STEP = "ImageBuildStep.msg";
    private String image;
    private DockerConnection connection;
    private int lines;
    ProgressJob progressJob;

    public ImageBuildProgressHandler(IDockerConnection connection, String image, int lines) {
        this.image = image;
        this.connection = (DockerConnection)connection;
        this.lines = lines;
    }

    public void processMessage(IDockerProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.stopAllJobs();
            throw new DockerImageBuildFailedException(this.image, message.error());
        }
        if (this.progressJob == null) {
            String status = message.stream();
            if (status != null && status.startsWith(DVMessages.getString(IMAGE_BUILD_COMPLETE))) {
                this.connection.getImages(true);
            } else {
                ProgressJob newJob = new ProgressJob(DVMessages.getFormattedString(IMAGE_BUILDING_JOBNAME, this.image), DVMessages.getString(IMAGE_BUILDING));
                newJob.setUser(true);
                newJob.setPriority(30);
                newJob.schedule();
                this.progressJob = newJob;
            }
        } else {
            String status = message.stream();
            if (status != null && status.startsWith(DVMessages.getString(IMAGE_BUILD_COMPLETE))) {
                this.progressJob.setPercentageDone(100);
                this.connection.getImages(true);
            } else if (status != null && status.startsWith(DVMessages.getString(IMAGE_BUILD_STEP))) {
                String stepNumber = status.substring(DVMessages.getString(IMAGE_BUILD_STEP).length());
                String[] tokens = stepNumber.split(" ");
                if (this.lines > 0) {
                    long percentage = (Long.valueOf(tokens[0]) + 1L) / (long)this.lines;
                    this.progressJob.setPercentageDone((int)percentage);
                }
            }
        }
    }

    private void stopAllJobs() {
        this.progressJob.cancel();
    }
}

