/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.swt.graphics.Image;

public class DockerExplorerLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    private static final String UNNAMED_CONNECTION = "Connection.unnamed";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (element instanceof IDockerConnection) {
            return SWTImagesFactory.DESC_REPOSITORY_MIDDLE.createImage();
        }
        if (element instanceof DockerExplorerContentProvider.DockerImagesCategory) {
            return SWTImagesFactory.DESC_DB_GROUP.createImage();
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainersCategory) {
            return SWTImagesFactory.DESC_DB_GROUP.createImage();
        }
        if (element instanceof IDockerImage) {
            return SWTImagesFactory.DESC_IMAGE.createImage();
        }
        if (element instanceof IDockerContainer) {
            IDockerContainer container = (IDockerContainer)element;
            EnumDockerStatus containerStatus = EnumDockerStatus.fromStatusMessage((String)container.status());
            if (containerStatus == EnumDockerStatus.RUNNING) {
                return SWTImagesFactory.DESC_CONTAINER_STARTED.createImage();
            }
            if (containerStatus == EnumDockerStatus.PAUSED) {
                return SWTImagesFactory.DESC_CONTAINER_PAUSED.createImage();
            }
            return SWTImagesFactory.DESC_CONTAINER_STOPPED.createImage();
        }
        if (element instanceof DockerExplorerContentProvider.LoadingStub) {
            return SWTImagesFactory.DESC_SYSTEM_PROCESS.createImage();
        }
        return null;
    }

    public String getText(Object element) {
        StyledString styledText = this.getStyledText(element);
        if (styledText != null) {
            return styledText.getString();
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IStructuredSelection) {
            return this.getStyledText(((IStructuredSelection)element).getFirstElement());
        }
        if (element instanceof IDockerConnection) {
            IDockerConnection connection = (IDockerConnection)element;
            String connectionName = connection.getName() != null && !connection.getName().isEmpty() ? connection.getName() : DVMessages.getString(UNNAMED_CONNECTION);
            String message = String.valueOf(connectionName) + " (" + connection.getUri() + ")";
            StyledString styledString = new StyledString(message);
            styledString.setStyle(connectionName.length(), message.length() - connectionName.length(), StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        if (element instanceof DockerExplorerContentProvider.DockerImagesCategory) {
            return new StyledString("Images");
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainersCategory) {
            return new StyledString("Containers");
        }
        if (element instanceof IDockerContainer) {
            IDockerContainer dockerContainer = (IDockerContainer)element;
            String containerName = dockerContainer.name();
            String image = dockerContainer.image();
            String message = String.valueOf(containerName) + " (" + image + ")";
            StyledString styledString = new StyledString(message);
            styledString.setStyle(containerName.length(), message.length() - containerName.length(), StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        if (element instanceof IDockerImage) {
            IDockerImage dockerImage = (IDockerImage)element;
            String imageShortId = dockerImage.id().substring(0, 12);
            StringBuilder messageBuilder = new StringBuilder(dockerImage.repo());
            int startTags = messageBuilder.length();
            if (!dockerImage.tags().isEmpty()) {
                ArrayList tags = new ArrayList(dockerImage.tags());
                Collections.sort(tags);
                messageBuilder.append(": ");
                Iterator tagIterator = tags.iterator();
                while (tagIterator.hasNext()) {
                    messageBuilder.append((String)tagIterator.next());
                    if (!tagIterator.hasNext()) continue;
                    messageBuilder.append(" / ");
                }
            }
            int startImageId = messageBuilder.length();
            messageBuilder.append(" (").append(imageShortId).append(')');
            String message = messageBuilder.toString();
            StyledString styledString = new StyledString(message);
            styledString.setStyle(startTags, startImageId - startTags, StyledString.COUNTER_STYLER);
            styledString.setStyle(startImageId, message.length() - startImageId, StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        if (element instanceof DockerExplorerContentProvider.LoadingStub) {
            return new StyledString("Loading...");
        }
        return null;
    }
}

