/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIUtils {
    private UIUtils() {
    }

    public static ISelection getWorkbenchWindowSelection() {
        return UIUtils.getActiveWorkbenchWindow().getSelectionService().getSelection();
    }

    public static IStructuredSelection getStructuredSelection() {
        ISelection selection = UIUtils.getWorkbenchWindowSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static <T> T getFirstElement(ISelection selection, Class<T> expectedClass) {
        if (selection == null) {
            return null;
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        if (firstElement != null && expectedClass.isAssignableFrom(firstElement.getClass())) {
            return (T)firstElement;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage workbenchPage = UIUtils.getActiveWorkbenchWindow().getActivePage();
        Assert.isNotNull((Object)workbenchPage);
        return workbenchPage;
    }

    public static IEditorPart getActiveEditor() {
        IEditorPart editor = UIUtils.getActivePage().getActiveEditor();
        Assert.isNotNull((Object)editor);
        return editor;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow workbenchWindow = UIUtils.getWorkbench().getActiveWorkbenchWindow();
        Assert.isNotNull((Object)workbenchWindow);
        return workbenchWindow;
    }

    public static IWorkbench getWorkbench() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Assert.isNotNull((Object)workbench);
        return workbench;
    }

    public static void replaceInJfaceImageRegistry(String imageKey, ImageDescriptor imageDescriptor) {
        Assert.isNotNull((Object)imageKey);
        Assert.isNotNull((Object)imageDescriptor);
        JFaceResources.getImageRegistry().remove(imageKey);
        JFaceResources.getImageRegistry().put(imageKey, imageDescriptor);
    }

    public static void registerContributionManager(String id, final IContributionManager contributionManager, Control control) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)contributionManager);
        Assert.isTrue((control != null && !control.isDisposed() ? 1 : 0) != 0);
        final IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)contributionManager, id);
        contributionManager.update(true);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menuService.releaseContributions((ContributionManager)contributionManager);
            }
        });
    }

    public static IMenuManager createContextMenu(Control control) {
        Assert.isTrue((control != null && !control.isDisposed() ? 1 : 0) != 0);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        return menuManager;
    }

    public static IDialogSettings getDialogSettings(String identifier, AbstractUIPlugin plugin) {
        Assert.isNotNull((Object)plugin);
        IDialogSettings dialogSettings = plugin.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(identifier);
        if (section == null) {
            section = dialogSettings.addNewSection(identifier);
        }
        return section;
    }

    public static IWorkbenchPage getPage(EditorPart editor) {
        Assert.isNotNull((Object)editor);
        IWorkbenchPartSite site = editor.getSite();
        Assert.isNotNull((Object)site);
        return site.getPage();
    }
}

