/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerContainer;

public class ContainerPropertyTester
extends PropertyTester {
    public static final String IS_RUNNING = "isRunning";
    public static final String IS_STOPPED = "isStopped";
    public static final String IS_PAUSED = "isPaused";
    public static final String IS_REMOVABLE = "isRemovable";
    public static final String IS_UNKNOWN = "isUnknown";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block19: {
            if (!(receiver instanceof IDockerContainer)) break block19;
            IDockerContainer container = (IDockerContainer)receiver;
            switch (property) {
                case "isRunning": {
                    return this.checkIfStateMatchesExpectation(container, EnumDockerStatus.RUNNING, expectedValue);
                }
                case "isStopped": {
                    return this.checkIfStateMatchesExpectation(container, EnumDockerStatus.STOPPED, expectedValue);
                }
                case "isUnknown": {
                    return this.checkIfStateMatchesExpectation(container, EnumDockerStatus.UNKNOWN, expectedValue);
                }
                case "isPaused": {
                    return this.checkIfStateMatchesExpectation(container, EnumDockerStatus.PAUSED, expectedValue);
                }
                case "isRemovable": {
                    return this.checkIfStateMatchesExpectation(container, EnumDockerStatus.STOPPED, expectedValue) || this.checkIfStateMatchesExpectation(container, EnumDockerStatus.UNKNOWN, expectedValue);
                }
            }
        }
        return false;
    }

    private boolean checkIfStateMatchesExpectation(IDockerContainer container, EnumDockerStatus expectedStatus, Object expectedMatch) {
        if (expectedMatch == null) {
            return false;
        }
        EnumDockerStatus containerStatus = EnumDockerStatus.fromStatusMessage((String)container.status());
        return expectedMatch.equals(containerStatus == expectedStatus);
    }
}

