/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.jobs.BuildDockerImageJob;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;

public class BuildDockerImageLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private static final String MISSING_CONNECTION_ERROR_MSG = "MissingConnectionError.msg";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String sourcePathLocation = configuration.getAttribute("sourcePathLocation", null);
        boolean sourcePathWorkspaceRelativeLocation = configuration.getAttribute("sourcePathWorkspaceRelativeLocation", false);
        IPath sourcePath = this.getPath(sourcePathLocation, sourcePathWorkspaceRelativeLocation);
        String connectionName = configuration.getAttribute("dockerConnection", null);
        DockerConnection connection = (DockerConnection)this.getDockerConnection(connectionName);
        if (connection == null) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", LaunchMessages.getFormattedString(MISSING_CONNECTION_ERROR_MSG, connectionName)));
        }
        try {
            BuildDockerImageJob buildImageJob = new BuildDockerImageJob((IDockerConnection)connection, sourcePath);
            buildImageJob.schedule();
        }
        catch (DockerException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", e.getMessage(), (Throwable)e));
        }
    }

    private IPath getPath(String sourcePathLocation, boolean sourcePathWorkspaceRelativeLocation) {
        if (sourcePathWorkspaceRelativeLocation) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(sourcePathLocation)).getLocation();
        }
        return new Path(sourcePathLocation);
    }

    private IDockerConnection getDockerConnection(String connectionName) {
        IDockerConnection[] iDockerConnectionArray = DockerConnectionManager.getInstance().getConnections();
        int n = iDockerConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            if (connection.getName().equals(connectionName)) {
                return connection;
            }
            ++n2;
        }
        return null;
    }
}

