/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImageBuildFailedException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.BuildConsole;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BuildDockerImageJob
extends Job
implements IDockerProgressHandler {
    private static final String BUILD_IMAGE_JOB_TITLE = "BuildImageJog.title";
    private static final String BUILD_IMAGE_ERROR_MESSAGE = "BuildImageError.msg";
    private static final String DOCKERFILE_LINE_COUNT_ERROR = "ImageBuildError.msg";
    private static final String SKIP_EMPTY_DOCKERFILE = "SkipEmptydockerfile.msg";
    private final IDockerConnection connection;
    private final IPath path;
    private final int numberOfBuildOperations;
    private final BuildConsole console;
    private IProgressMonitor progressMonitor;

    public BuildDockerImageJob(IDockerConnection connection, IPath path) throws DockerException {
        super(JobMessages.getString(BUILD_IMAGE_JOB_TITLE));
        this.connection = connection;
        this.path = path;
        this.console = BuildConsole.findConsole();
        this.numberOfBuildOperations = BuildDockerImageJob.countLines(path.addTrailingSeparator().append("dockerFile").toOSString());
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        try {
            if (this.numberOfBuildOperations == 0) {
                Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.ui", JobMessages.getString(SKIP_EMPTY_DOCKERFILE)));
            } else {
                this.console.clearConsole();
                this.console.activate();
                this.progressMonitor = progressMonitor;
                this.progressMonitor.beginTask(JobMessages.getString(BUILD_IMAGE_JOB_TITLE), this.numberOfBuildOperations + 1);
                this.connection.buildImage(this.path, (IDockerProgressHandler)this);
                this.connection.getImages(true);
            }
        }
        catch (InterruptedException | DockerException e) {
            Display.getDefault().syncExec(new Runnable((Exception)e){
                private final /* synthetic */ Exception val$e;
                {
                    this.val$e = exception;
                }

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)JobMessages.getString(BuildDockerImageJob.BUILD_IMAGE_ERROR_MESSAGE), (String)this.val$e.getMessage());
                }
            });
        }
        this.progressMonitor.done();
        return Status.OK_STATUS;
    }

    public void processMessage(IDockerProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.cancel();
            throw new DockerImageBuildFailedException(message.error());
        }
        String status = message.stream();
        if (status != null && status.startsWith("Successfully built")) {
            this.connection.getImages(true);
        } else if (status != null && status.startsWith("Step")) {
            this.progressMonitor.worked(1);
        }
        this.logMessage(status);
    }

    private void logMessage(final String buildMessage) {
        if (this.console != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BuildDockerImageJob.this.console.showConsole();
                    try {
                        BuildDockerImageJob.this.console.write(buildMessage.getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        Activator.log(e);
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int countLines(String fileName) throws DockerException {
        try {
            int count = 0;
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(fileName);
                try {
                    block21: {
                        InputStreamReader isr = new InputStreamReader(fis);
                        try {
                            try (BufferedReader br = new BufferedReader(isr);){
                                String line;
                                while ((line = br.readLine()) != null) {
                                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                                    ++count;
                                }
                            }
                            if (isr == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (isr == null) throw throwable;
                            isr.close();
                            throw throwable;
                        }
                        isr.close();
                    }
                    if (fis == null) return count;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    ((InputStream)fis).close();
                    throw throwable;
                }
                ((InputStream)fis).close();
                return count;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DockerException(JobMessages.getString(DOCKERFILE_LINE_COUNT_ERROR), (Throwable)e);
        }
    }
}

