/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseContainersCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoveContainersCommandHandler
extends BaseContainersCommandHandler {
    private static final String CONTAINERS_REMOVE_MSG = "ContainersRemove.msg";
    private static final String CONTAINER_REMOVE_MSG = "ContainerRemove.msg";
    private static final String CONTAINER_REMOVE_ERROR_MSG = "ContainerRemoveError.msg";
    private static final String CONTAINER_REMOVE_CONFIRM = "ContainerRemoveConfirm.msg";
    private static final String CONTAINER_REMOVE_LIST = "ContainerRemoveList.msg";

    @Override
    void executeInJob(IDockerContainer container, IDockerConnection connection) {
        try {
            try {
                connection.removeContainer(container.id());
                RunConsole rc = RunConsole.findConsole(container.id());
                if (rc != null) {
                    RunConsole.removeConsole(rc);
                }
            }
            catch (InterruptedException | DockerException e) {
                String errorMessage = DVMessages.getFormattedString(CONTAINER_REMOVE_ERROR_MSG, container.name());
                this.openError(errorMessage, (Exception)e);
                connection.getContainers(true);
            }
        }
        finally {
            connection.getContainers(true);
        }
    }

    @Override
    String getJobName(List<IDockerContainer> selectedContainers) {
        return DVMessages.getString(CONTAINERS_REMOVE_MSG);
    }

    @Override
    String getTaskName(IDockerContainer image) {
        return DVMessages.getFormattedString(CONTAINER_REMOVE_MSG, image.name());
    }

    @Override
    boolean confirmed(List<IDockerContainer> selectedContainers) {
        ArrayList<String> containersToRemove = new ArrayList<String>();
        for (IDockerContainer container : selectedContainers) {
            containersToRemove.add(container.name());
        }
        final ArrayList<String> names = containersToRemove;
        final DialogResponse response = new DialogResponse();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean result = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)DVMessages.getString(RemoveContainersCommandHandler.CONTAINER_REMOVE_CONFIRM), (String)DVMessages.getFormattedString(RemoveContainersCommandHandler.CONTAINER_REMOVE_LIST, names.toString()));
                response.setResponse(result);
            }
        });
        return response.getResponse();
    }

    private class DialogResponse {
        private boolean response;

        private DialogResponse() {
        }

        public boolean getResponse() {
            return this.response;
        }

        public void setResponse(boolean value) {
            this.response = value;
        }
    }
}

