/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.ImagePullProgressHandler;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePull;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class PullImageCommandHandler
extends AbstractHandler {
    private static final String PULL_IMAGE_JOB_TITLE = "ImagePull.title";
    private static final String PULL_IMAGE_JOB_TASK = "ImagePull.msg";
    private static final String ERROR_PULLING_IMAGE = "ImagePullError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        ImagePull wizard = new ImagePull(connection);
        boolean pullImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (pullImage) {
            this.performPullImage(connection, wizard.getImageName());
        }
        return null;
    }

    private void performPullImage(final IDockerConnection connection, final String imageName) {
        Job pullImageJob = new Job(DVMessages.getFormattedString(PULL_IMAGE_JOB_TITLE, imageName)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(PullImageCommandHandler.PULL_IMAGE_JOB_TASK), -1);
                try {
                    try {
                        ((DockerConnection)connection).pullImage(imageName, (IDockerProgressHandler)new ImagePullProgressHandler(connection, imageName));
                    }
                    catch (DockerException e) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(PullImageCommandHandler.ERROR_PULLING_IMAGE, imageName), (String)e.getMessage());
                            }
                        });
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        pullImageJob.schedule();
    }
}

