/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.resource.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheCoordinationType implements Enumerator
{
    SEND_OBJECT_CHANGES(0, "SEND_OBJECT_CHANGES", "SEND_OBJECT_CHANGES"),
    INVALIDATE_CHANGED_OBJECTS(1, "INVALIDATE_CHANGED_OBJECTS", "INVALIDATE_CHANGED_OBJECTS"),
    SEND_NEW_OBJECTS_WITH_CHANGES(2, "SEND_NEW_OBJECTS_WITH_CHANGES", "SEND_NEW_OBJECTS_WITH_CHANGES"),
    NONE(3, "NONE", "NONE");

    public static final int SEND_OBJECT_CHANGES_VALUE = 0;
    public static final int INVALIDATE_CHANGED_OBJECTS_VALUE = 1;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES_VALUE = 2;
    public static final int NONE_VALUE = 3;
    private static final CacheCoordinationType[] VALUES_ARRAY;
    public static final List<CacheCoordinationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheCoordinationType[]{SEND_OBJECT_CHANGES, INVALIDATE_CHANGED_OBJECTS, SEND_NEW_OBJECTS_WITH_CHANGES, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheCoordinationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheCoordinationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheCoordinationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheCoordinationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheCoordinationType get(int value) {
        switch (value) {
            case 0: {
                return SEND_OBJECT_CHANGES;
            }
            case 1: {
                return INVALIDATE_CHANGED_OBJECTS;
            }
            case 2: {
                return SEND_NEW_OBJECTS_WITH_CHANGES;
            }
            case 3: {
                return NONE;
            }
        }
        return null;
    }

    private CacheCoordinationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

