/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigEditPage;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigModePage;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigTypePage;

public class NewLaunchConfigWizard
extends Wizard
implements ILaunchConfigurationListener {
    NewLaunchConfigModePage modePage = new NewLaunchConfigModePage();
    NewLaunchConfigTypePage typePage = new NewLaunchConfigTypePage();
    NewLaunchConfigEditPage editPage = new NewLaunchConfigEditPage();
    private List<ILaunchConfiguration> configsToDelete = new ArrayList<ILaunchConfiguration>();

    public NewLaunchConfigWizard() {
        this.setWindowTitle(Messages.NewLaunchConfigWizard_0);
        this.initListeners();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.modePage);
        this.addPage((IWizardPage)this.typePage);
        this.addPage((IWizardPage)this.editPage);
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.editPage.workingCopy;
    }

    public ILaunchMode getLaunchMode() {
        String initMode = this.modePage.selectedGroup.getMode();
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(initMode);
    }

    public boolean performFinish() {
        this.cleanUpConfigs();
        return this.editPage.performFinish();
    }

    public boolean performCancel() {
        this.cleanUpConfigs();
        return super.performCancel();
    }

    private void initListeners() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    void cleanUpConfigs() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        for (ILaunchConfiguration config : this.configsToDelete) {
            try {
                config.delete();
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.configsToDelete.add(configuration);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.configsToDelete.remove(configuration);
        }
    }
}

