/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPropertiesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class LaunchConfigurationEditDialog
extends LaunchConfigurationPropertiesDialog {
    private static final int DELETE_ID = 64;
    private static final int DUPLICATE_ID = 65;
    private static final int LAUNCH_ID = 66;

    public LaunchConfigurationEditDialog(Shell shell, ILaunchConfiguration launchConfiguration, LaunchGroupExtension group) {
        super(shell, launchConfiguration, group);
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        Composite leftButtonComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.numColumns = 0;
        leftButtonComp.setLayout((Layout)layout);
        leftButtonComp.setLayoutData((Object)new GridData(768));
        leftButtonComp.setFont(parent.getFont());
        this.createButton(leftButtonComp, 64, Messages.LaunchConfigurationEditDialog_0, false);
        this.createButton(leftButtonComp, 65, Messages.LaunchConfigurationEditDialog_1, false);
        this.createButton(leftButtonComp, 66, this.getLaunchButtonText(), false);
        Composite mainButtonComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.numColumns = 0;
        mainButtonComp.setLayout((Layout)layout);
        mainButtonComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        mainButtonComp.setFont(parent.getFont());
        this.createButton(mainButtonComp, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(mainButtonComp, 1, IDialogConstants.CANCEL_LABEL, false);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 64: {
                ILaunchConfiguration c = this.getLaunchConfiguration();
                if (c.isWorkingCopy()) {
                    c = ((ILaunchConfigurationWorkingCopy)c).getOriginal();
                }
                final ILaunchConfiguration config = c;
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.LaunchConfigurationEditDialog_3, (String)(String.valueOf(Messages.LaunchConfigurationEditDialog_4) + config.getName()))) break;
                new Job(Messages.LaunchConfigurationEditDialog_5){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            config.delete();
                            return Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                    }
                }.schedule();
                this.cancelPressed();
                break;
            }
            case 65: {
                final ILaunchConfiguration original = this.getLaunchConfiguration();
                final String newName = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(original.getName());
                final Shell shell = this.getParentShell();
                final LaunchGroupExtension group = this.getLaunchGroup();
                new UIJob(Messages.LaunchConfigurationEditDialog_6){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            ILaunchConfigurationWorkingCopy newWorkingCopy = original.copy(newName);
                            ILaunchConfiguration newConfig = newWorkingCopy.doSave();
                            new LaunchConfigurationEditDialog(shell, newConfig, group).open();
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                this.cancelPressed();
                break;
            }
            case 66: {
                this.okPressed();
                Activator.runCommand("org.eclipse.launchbar.ui.command.launchActive", new String[0]);
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }
}

