/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class Transition
implements Runnable {
    private final Control control;
    private final int tick;
    private int current;
    private int to;
    private int incr;

    public Transition(Control control, int current, int tick) {
        this.control = control;
        this.current = current;
        this.tick = tick;
    }

    @Override
    public void run() {
        this.current += this.incr;
        if (!this.control.isDisposed()) {
            this.control.redraw();
        }
        if (!this.done()) {
            Display.getCurrent().timerExec(this.tick, (Runnable)this);
        }
    }

    public void to(int to) {
        if (this.current == to) {
            return;
        }
        this.to = to;
        this.incr = this.current > to ? -1 : 1;
        Display.getCurrent().timerExec(this.tick, (Runnable)this);
    }

    public int getCurrent() {
        return this.current;
    }

    public boolean done() {
        return this.current == this.to;
    }
}

