/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.launchbar.ui.IHoverProvider;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.controls.EditButton;
import org.eclipse.launchbar.ui.internal.controls.LaunchBarListViewer;
import org.eclipse.launchbar.ui.internal.controls.Transition;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class CSelector
extends Composite {
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private IHoverProvider hoverProvider;
    private Comparator<?> sorter;
    private Comparator<?> sorterTop;
    private Object input;
    private Composite buttonComposite;
    private String toolTipText;
    private boolean toolTipWasModified;
    private static final int arrowMax = 2;
    private Transition arrowTransition;
    private Object selection;
    protected final Color backgroundColor;
    protected final Color outlineColor;
    protected final Color highlightColor;
    protected final Color white;
    private boolean mouseOver;
    private Label currentIcon;
    private Label currentLabel;
    private Shell popup;
    private LaunchBarListViewer listViewer;
    private Job delayJob;
    private MouseTrackListener mouseTrackListener = new MouseTrackListener(){

        public void mouseEnter(MouseEvent e) {
            if (!CSelector.this.mouseOver) {
                CSelector.this.mouseOver = true;
                CSelector.this.redraw();
                if (CSelector.this.toolTipWasModified) {
                    CSelector.this.buttonComposite.setToolTipText(CSelector.this.toolTipText);
                    if (CSelector.this.currentLabel != null) {
                        CSelector.this.currentLabel.setToolTipText(CSelector.this.toolTipText);
                    }
                    if (CSelector.this.currentIcon != null) {
                        CSelector.this.currentIcon.setToolTipText(CSelector.this.toolTipText);
                    }
                }
            }
        }

        public void mouseHover(MouseEvent e) {
            Object eventSource;
            if (CSelector.this.hoverProvider != null && (CSelector.this.popup == null || CSelector.this.popup.isDisposed()) && ((eventSource = e.getSource()) == CSelector.this.currentLabel || eventSource == CSelector.this.buttonComposite || eventSource == CSelector.this.currentIcon) && CSelector.this.hoverProvider.displayHover(CSelector.this.selection)) {
                CSelector.this.buttonComposite.setToolTipText("");
                if (CSelector.this.currentLabel != null) {
                    CSelector.this.currentLabel.setToolTipText("");
                }
                if (CSelector.this.currentIcon != null) {
                    CSelector.this.currentIcon.setToolTipText("");
                }
                CSelector.this.toolTipWasModified = true;
            }
        }

        public void mouseExit(MouseEvent e) {
            if (CSelector.this.mouseOver) {
                CSelector.this.mouseOver = false;
                CSelector.this.redraw();
            }
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseUp(MouseEvent event) {
            if (CSelector.this.popup == null || CSelector.this.popup.isDisposed()) {
                CSelector.this.setFocus();
                CSelector.this.openPopup();
            } else {
                CSelector.this.closePopup();
            }
        }
    };
    private Listener focusOutListener = new Listener(){
        private Job closingJob;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    if (this.closingJob != null) {
                        this.closingJob.cancel();
                    }
                    if (event.widget instanceof Control && CSelector.this.myIsFocusAncestor((Control)event.widget) || CSelector.this.isPopUpInFocus()) break;
                    CSelector.this.closePopup();
                    break;
                }
                case 16: {
                    if (!CSelector.this.isPopUpInFocus()) break;
                    if (this.closingJob != null) {
                        this.closingJob.cancel();
                    }
                    this.closingJob = new Job(Messages.CSelector_0){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            CSelector.this.closePopup();
                            closingJob = null;
                            return Status.OK_STATUS;
                        }
                    };
                    this.closingJob.schedule(300L);
                    break;
                }
                case 4: {
                    if (CSelector.this.popup == null || CSelector.this.popup.isDisposed()) break;
                    Point loc = CSelector.this.getDisplay().getCursorLocation();
                    if (CSelector.this.popup.getBounds().contains(loc) || CSelector.this.getBounds().contains(CSelector.this.getParent().toControl(loc))) break;
                    CSelector.this.closePopup();
                }
            }
        }
    };

    protected boolean myIsFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.getParent();
        }
        return control == this;
    }

    public CSelector(Composite parent, int style) {
        super(parent, style);
        this.backgroundColor = this.getDisplay().getSystemColor(25);
        this.outlineColor = this.getDisplay().getSystemColor(18);
        this.highlightColor = this.getDisplay().getSystemColor(26);
        this.white = this.getDisplay().getSystemColor(1);
        GridLayout mainButtonLayout = new GridLayout();
        this.setLayout((Layout)mainButtonLayout);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setBackground(CSelector.this.backgroundColor);
                gc.setForeground(CSelector.this.outlineColor);
                Point size = CSelector.this.getSize();
                gc.fillRoundRectangle(0, 0, size.x - 1, size.y - 1, 3, 3);
                gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, 3, 3);
            }
        });
        this.addMouseListener(this.mouseListener);
        this.addMouseTrackListener(this.mouseTrackListener);
    }

    private boolean isPopUpInFocus() {
        Control focusControl = this.getDisplay().getFocusControl();
        return focusControl != null && focusControl.getShell() == this.popup;
    }

    public void dispose() {
        super.dispose();
        if (this.popup != null) {
            this.popup.dispose();
        }
    }

    public void setDelayedSelection(final Object element, long millis) {
        if (this.delayJob != null) {
            this.delayJob.cancel();
        }
        this.delayJob = new Job(Messages.CSelector_1){

            protected IStatus run(final IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (CSelector.this.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                CSelector.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        CSelector.this.setSelection(element);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.delayJob.schedule(millis);
    }

    public void setSelection(Object element) {
        if (this.isDisposed()) {
            return;
        }
        this.selection = element;
        if (this.buttonComposite != null) {
            this.buttonComposite.dispose();
        }
        this.toolTipText = this.getToolTipText();
        boolean editable = false;
        int columns = 2;
        Image image = this.labelProvider.getImage(element);
        if (image != null) {
            ++columns;
        }
        if (editable = this.isEditable(element)) {
            ++columns;
        }
        this.buttonComposite = new Composite((Composite)this, 0);
        GridLayout buttonLayout = new GridLayout(columns, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        this.buttonComposite.setLayout((Layout)buttonLayout);
        this.buttonComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buttonComposite.setBackground(this.backgroundColor);
        this.buttonComposite.addMouseListener(this.mouseListener);
        this.buttonComposite.addMouseTrackListener(this.mouseTrackListener);
        this.buttonComposite.setToolTipText(this.toolTipText);
        if (element != null) {
            if (image != null) {
                Label icon = this.createImage(this.buttonComposite, image);
                icon.addMouseListener(this.mouseListener);
                icon.addMouseTrackListener(this.mouseTrackListener);
                this.currentIcon = icon;
                this.currentIcon.setToolTipText(this.toolTipText);
            }
            Label label = this.createLabel(this.buttonComposite, element);
            label.addMouseListener(this.mouseListener);
            label.addMouseTrackListener(this.mouseTrackListener);
            this.currentLabel = label;
            this.currentLabel.setToolTipText(this.toolTipText);
        } else {
            Composite blank = new Composite(this.buttonComposite, 0);
            blank.setLayoutData((Object)new GridData(4, 4, true, true));
            this.currentIcon = null;
            this.currentLabel = null;
        }
        final Canvas arrow = new Canvas(this.buttonComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(12, 16);
            }
        };
        arrow.setLayoutData((Object)new GridData(4, 4, false, true));
        arrow.setBackground(this.backgroundColor);
        this.arrowTransition = new Transition((Control)arrow, 2, 80);
        arrow.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                LineAttributes attributes = new LineAttributes(2.0f);
                attributes.cap = 2;
                gc.setLineAttributes(attributes);
                gc.setAlpha(CSelector.this.mouseOver ? 255 : 100);
                Rectangle bounds = arrow.getBounds();
                int arrowWidth = bounds.width - 4;
                int current = CSelector.this.arrowTransition.getCurrent();
                gc.drawPolyline(new int[]{2, bounds.height / 2 - current, 2 + arrowWidth / 2, bounds.height / 2 + current, 2 + arrowWidth, bounds.height / 2 - current});
            }
        });
        arrow.addMouseListener(this.mouseListener);
        arrow.addMouseTrackListener(this.mouseTrackListener);
        if (editable) {
            EditButton editButton = new EditButton(this.buttonComposite, 0);
            editButton.setLayoutData(new GridData(4, 0x1000000, false, true));
            editButton.setBackground(this.backgroundColor);
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSelector.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CSelector.this.selection != null) {
                                CSelector.this.handleEdit(CSelector.this.selection);
                            }
                        }
                    });
                }
            });
        }
        this.layout();
    }

    protected abstract void fireSelectionChanged();

    public Object getSelection() {
        return this.selection;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseTrackListener getMouseTrackListener() {
        return this.mouseTrackListener;
    }

    protected void openPopup() {
        Object[] elements = this.contentProvider.getElements(this.input);
        if (elements.length == 0 && !this.hasActionArea()) {
            return;
        }
        this.arrowTransition.to(-2);
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.dispose();
        }
        this.popup = new Shell(this.getShell(), 16404);
        this.popup.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.listViewer = new LaunchBarListViewer((Composite)this.popup);
        this.initializeListViewer(this.listViewer);
        this.listViewer.setFilterVisible(elements.length > 7);
        this.listViewer.setInput(this.input);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CSelector.this.listViewer.isFinalSelection()) {
                    return;
                }
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                if (!ss.isEmpty()) {
                    CSelector.this.setSelection(ss.getFirstElement());
                    CSelector.this.fireSelectionChanged();
                }
                CSelector.this.closePopup();
            }
        });
        if (this.hasActionArea()) {
            this.createActionArea((Composite)this.popup);
        }
        Rectangle buttonBounds = this.getBounds();
        Point popupLocation = this.popup.getDisplay().map((Control)this, null, 0, buttonBounds.height);
        this.popup.setLocation(popupLocation.x, popupLocation.y + 5);
        this.restoreShellSize();
        this.popup.setVisible(true);
        this.popup.setFocus();
        this.getDisplay().addFilter(15, this.focusOutListener);
        this.getDisplay().addFilter(16, this.focusOutListener);
        this.getDisplay().addFilter(4, this.focusOutListener);
        this.popup.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CSelector.this.getDisplay().removeFilter(15, CSelector.this.focusOutListener);
                CSelector.this.getDisplay().removeFilter(16, CSelector.this.focusOutListener);
                CSelector.this.getDisplay().removeFilter(4, CSelector.this.focusOutListener);
                CSelector.this.saveShellSize();
            }
        });
        if (this.hoverProvider != null) {
            this.hoverProvider.dismissHover(this.selection != null ? this.selection : null, true);
        }
    }

    protected String getDialogPreferencePrefix() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void restoreShellSize() {
        Point size = this.popup.computeSize(-1, -1);
        Point buttonSize = this.getSize();
        size.x = Math.max(size.x, buttonSize.x);
        size.y = Math.min(size.y, 300);
        try {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String prefName = this.getDialogPreferencePrefix();
            int w = store.getInt(String.valueOf(prefName) + ".shell.w");
            int h = store.getInt(String.valueOf(prefName) + ".shell.h");
            size.x = Math.max(size.x, w);
            size.y = Math.max(size.y, h);
        }
        catch (Exception e) {
            Activator.log(e);
        }
        this.popup.setSize(size);
    }

    protected void saveShellSize() {
        Point size = this.popup.getSize();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String prefName = this.getDialogPreferencePrefix();
        store.setValue(String.valueOf(prefName) + ".shell.w", size.x);
        store.setValue(String.valueOf(prefName) + ".shell.h", size.y);
    }

    protected void initializeListViewer(LaunchBarListViewer listViewer) {
        listViewer.setContentProvider((IContentProvider)this.contentProvider);
        listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        listViewer.setComparator(this.sorter);
        listViewer.setHistoryComparator(this.sorterTop);
    }

    private void closePopup() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CSelector.this.popup == null || CSelector.this.popup.isDisposed()) {
                    return;
                }
                CSelector.this.arrowTransition.to(2);
                CSelector.this.popup.setVisible(false);
                CSelector.this.popup.dispose();
            }
        });
    }

    private Label createImage(Composite parent, Image image) {
        Rectangle bounds = image.getBounds();
        boolean disposeImage = false;
        if (bounds.height > 16 || bounds.width > 16) {
            Image buttonImage = new Image((Device)this.getDisplay(), 16, 16);
            GC gc = new GC((Drawable)buttonImage);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, 16, 16);
            gc.dispose();
            image = buttonImage;
            disposeImage = true;
        }
        Label icon = new Label(parent, 0);
        icon.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        icon.setImage(image);
        if (disposeImage) {
            final Image disposableImage = image;
            icon.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    disposableImage.dispose();
                }
            });
        }
        return icon;
    }

    private Label createLabel(Composite parent, Object element) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        label.setText(this.labelProvider.getText(element));
        label.setFont(this.getDisplay().getSystemFont());
        return label;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setHoverProvider(IHoverProvider hoverProvider) {
        this.hoverProvider = hoverProvider;
    }

    public IHoverProvider getHoverProvider() {
        return this.hoverProvider;
    }

    public void setSorter(Comparator<?> sorter) {
        this.sorter = sorter;
    }

    public void setHistorySortComparator(Comparator<?> sorter) {
        this.sorterTop = sorter;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
    }

    public void update(Object element) {
        if (this.selection == element) {
            if (this.currentIcon != null && !this.currentIcon.isDisposed()) {
                this.currentIcon.setImage(this.labelProvider.getImage(element));
            }
            if (this.currentLabel != null && !this.currentLabel.isDisposed()) {
                this.currentLabel.setText(this.labelProvider.getText(element));
            }
        }
        if (this.popup != null && !this.popup.isDisposed()) {
            this.listViewer.update(element, null);
        }
    }

    protected boolean hasActionArea() {
        return false;
    }

    protected void createActionArea(Composite parent) {
    }

    protected boolean isEditable(Object element) {
        return false;
    }

    protected void handleEdit(Object element) {
    }
}

