/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import java.util.HashSet;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.ui.details.JptJpaEclipseLinkUiDetailsMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkConversionValueStateObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConversionValueDialog
extends ValidatingDialog<EclipseLinkConversionValueStateObject> {
    private final EclipseLinkObjectTypeConverter objectTypeConverter;
    private final EclipseLinkConversionValue conversionValue;

    public EclipseLinkConversionValueDialog(Shell parentShell, ResourceManager resourceManager, EclipseLinkObjectTypeConverter objectTypeConverter) {
        this(parentShell, resourceManager, objectTypeConverter, null);
    }

    public EclipseLinkConversionValueDialog(Shell parentShell, ResourceManager resourceManager, EclipseLinkObjectTypeConverter objectTypeConverter, EclipseLinkConversionValue conversionValue) {
        super(parentShell, resourceManager, EclipseLinkConversionValueDialog.buildTitle(conversionValue));
        this.objectTypeConverter = objectTypeConverter;
        this.conversionValue = conversionValue;
    }

    private static String buildTitle(EclipseLinkConversionValue conversionValue) {
        return conversionValue == null ? JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_ADD_CONVERSION_VALUE : JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_EDIT_CONVERSION_VALUE;
    }

    protected EclipseLinkConversionValueStateObject buildStateObject() {
        String dataValue = null;
        String objectValue = null;
        HashSet dataValues = CollectionTools.set((Iterable)this.objectTypeConverter.getDataValues(), (int)this.objectTypeConverter.getDataValuesSize());
        if (this.isEditDialog()) {
            dataValue = this.conversionValue.getDataValue();
            objectValue = this.conversionValue.getObjectValue();
            dataValues.remove(dataValue);
        }
        return new EclipseLinkConversionValueStateObject(dataValue, objectValue, dataValues);
    }

    protected String getDescriptionTitle() {
        return this.isAddDialog() ? JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_ADD_CONVERSION_VALUE_DESCRIPTION_TITLE : JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_EDIT_CONVERSION_VALUE_DESCRIPTION_TITLE;
    }

    protected String getDescription() {
        return this.isAddDialog() ? JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_ADD_CONVERSION_VALUE_DESCRIPTION : JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_EDIT_CONVERSION_VALUE_DESCRIPTION;
    }

    protected DialogPane<EclipseLinkConversionValueStateObject> buildLayout(Composite container) {
        return new ConversionValueDialogPane((PropertyValueModel<EclipseLinkConversionValueStateObject>)this.getSubjectHolder(), container, this.resourceManager);
    }

    public void create() {
        super.create();
        this.getPane().selectAll();
        this.getButton(0).setEnabled(false);
    }

    protected ConversionValueDialogPane getPane() {
        return (ConversionValueDialogPane)super.getPane();
    }

    protected boolean isAddDialog() {
        return this.conversionValue == null;
    }

    protected boolean isEditDialog() {
        return !this.isAddDialog();
    }

    public String getDataValue() {
        return ((EclipseLinkConversionValueStateObject)this.getSubject()).getDataValue();
    }

    public String getObjectValue() {
        return ((EclipseLinkConversionValueStateObject)this.getSubject()).getObjectValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConversionValueDialogPane
    extends DialogPane<EclipseLinkConversionValueStateObject> {
        private Text dataValueText;
        private Text objectValueText;

        ConversionValueDialogPane(PropertyValueModel<EclipseLinkConversionValueStateObject> subjectModel, Composite parentComposite, ResourceManager resourceManager) {
            super(subjectModel, parentComposite, resourceManager);
        }

        protected Composite addComposite(Composite container) {
            return this.addSubPane(container, 2, 0, 0, 0, 0);
        }

        protected void initializeLayout(Composite container) {
            this.addLabel(container, JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_DATA_VALUE);
            this.dataValueText = this.addText(container, this.buildDataValueHolder());
            this.addLabel(container, JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_DIALOG_OBJECT_VALUE);
            this.objectValueText = this.addText(container, this.buildObjectValueHolder());
        }

        private ModifiablePropertyValueModel<String> buildDataValueHolder() {
            return new PropertyAspectAdapter<EclipseLinkConversionValueStateObject, String>(this.getSubjectHolder(), new String[]{"dataValue"}){

                protected String buildValue_() {
                    return ((EclipseLinkConversionValueStateObject)((Object)this.subject)).getDataValue();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConversionValueStateObject)((Object)this.subject)).setDataValue(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildObjectValueHolder() {
            return new PropertyAspectAdapter<EclipseLinkConversionValueStateObject, String>(this.getSubjectHolder(), new String[]{"objectValue"}){

                protected String buildValue_() {
                    return ((EclipseLinkConversionValueStateObject)((Object)this.subject)).getObjectValue();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConversionValueStateObject)((Object)this.subject)).setObjectValue(value);
                }
            };
        }

        void selectAll() {
            this.dataValueText.selectAll();
            this.objectValueText.selectAll();
        }
    }
}

