/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.FileExtensionsServiceData;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DeclarativeFileExtensionsService
extends FileExtensionsService {
    private FunctionResult functionResult;

    @Override
    protected void initFileExtensionsService() {
        FileExtensions fileExtensionsAnnotation = this.context(PropertyDef.class).getAnnotation(FileExtensions.class);
        Function function = null;
        try {
            function = ExpressionLanguageParser.parse(fileExtensionsAnnotation.expr());
        }
        catch (Exception e) {
            Sapphire.service(LoggingService.class).log(e);
            function = null;
        }
        if (function != null) {
            function = FailSafeFunction.create(function, Literal.create(List.class), Literal.create(Collections.emptyList()));
            this.functionResult = function.evaluate(new ModelElementFunctionContext(this.context(Element.class)));
            this.functionResult.attach(new Listener(){

                @Override
                public void handle(Event event) {
                    DeclarativeFileExtensionsService.this.refresh();
                }
            });
        }
    }

    @Override
    protected FileExtensionsServiceData compute() {
        ArrayList<String> extensions = new ArrayList<String>();
        if (this.functionResult != null) {
            for (Object extension : (List)this.functionResult.value()) {
                extensions.add((String)extension);
            }
        }
        return new FileExtensionsServiceData(extensions);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(FileExtensions.class);
        }
    }
}

