/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.block;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class ParagraphBlock
extends Block {
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount > 0) {
            this.builder.characters("\n");
        }
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        ++this.blockLineCount;
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
            this.builder.characters("\n");
        }
        super.setClosed(closed);
    }
}

