/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class HeadingBlock
extends Block {
    private static final Pattern pattern = Pattern.compile("(={1,})\\s*(.+?)(\\s*)((?:=*\\s*))?");
    private Matcher matcher;

    public boolean canStart(String line, int lineOffset) {
        Matcher m;
        if (lineOffset == 0 && (m = pattern.matcher(line)).matches() && m.group(1).length() < 6) {
            this.matcher = m;
            return true;
        }
        this.matcher = null;
        return false;
    }

    public int processLineContent(String line, int offset) {
        int level = this.matcher.group(1).length();
        String text = this.matcher.group(2);
        String closingGroup = this.matcher.group(4);
        this.builder.beginHeading(level, new Attributes());
        this.builder.characters(text);
        if (closingGroup.length() > 0 && closingGroup.length() != level) {
            this.builder.characters(this.matcher.group(3));
            this.builder.characters(closingGroup);
        }
        this.builder.endHeading();
        this.setClosed(true);
        return -1;
    }
}

