/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.DeleteAll;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OrderColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConvertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.OrderByMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

public abstract class CollectionAccessor
extends RelationshipAccessor
implements MappedKeyMapAccessor {
    private Boolean m_deleteAll;
    private ColumnMetadata m_mapKeyColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private ForeignKeyMetadata m_mapKeyForeignKey;
    private List<ConvertMetadata> m_mapKeyConverts;
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<JoinColumnMetadata> m_mapKeyJoinColumns = new ArrayList<JoinColumnMetadata>();
    private MapKeyMetadata m_mapKey;
    private MetadataClass m_mapKeyClass;
    private OrderByMetadata m_orderBy;
    private OrderColumnMetadata m_orderColumn;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private TemporalMetadata m_mapKeyTemporal;

    protected CollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected CollectionAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        int n;
        this.setMappedBy(annotation == null ? "" : annotation.getAttributeString("mappedBy"));
        if (this.isAnnotationPresent("javax.persistence.OrderBy")) {
            this.m_orderBy = new OrderByMetadata(this.getAnnotation("javax.persistence.OrderBy"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.MapKey")) {
            this.m_mapKey = new MapKeyMetadata(this.getAnnotation("javax.persistence.MapKey"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.MapKeyClass")) {
            this.m_mapKeyClass = this.getMetadataClass(this.getAnnotation("javax.persistence.MapKeyClass").getAttributeString("value"));
        }
        if (this.isAnnotationPresent("javax.persistence.MapKeyColumn")) {
            this.m_mapKeyColumn = new ColumnMetadata(this.getAnnotation("javax.persistence.MapKeyColumn"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.MapKeyJoinColumns")) {
            MetadataAnnotation mapKeyJoinColumns = this.getAnnotation("javax.persistence.MapKeyJoinColumns");
            Object[] objectArray = mapKeyJoinColumns.getAttributeArray("value");
            int n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object mapKeyJoinColumn = objectArray[n];
                this.m_mapKeyJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)mapKeyJoinColumn, this));
                ++n;
            }
            if (mapKeyJoinColumns.hasAttribute("foreignKey")) {
                this.setMapKeyForeignKey(new ForeignKeyMetadata(mapKeyJoinColumns.getAttributeAnnotation("foreignKey"), this));
            }
        }
        if (this.isAnnotationPresent("javax.persistence.MapKeyJoinColumn")) {
            JoinColumnMetadata mapKeyJoinColumn = new JoinColumnMetadata(this.getAnnotation("javax.persistence.MapKeyJoinColumn"), this);
            this.m_mapKeyJoinColumns.add(mapKeyJoinColumn);
            this.setMapKeyForeignKey(mapKeyJoinColumn.getForeignKey());
        }
        if (this.isAnnotationPresent("javax.persistence.AttributeOverrides")) {
            Object[] objectArray = this.getAnnotation("javax.persistence.AttributeOverrides").getAttributeArray("value");
            n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object attributeOverride = objectArray[n3];
                this.addAttributeOverride(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, this));
                ++n3;
            }
        }
        if (this.isAnnotationPresent("javax.persistence.AttributeOverride")) {
            this.addAttributeOverride(new AttributeOverrideMetadata(this.getAnnotation("javax.persistence.AttributeOverride"), this));
        }
        if (this.isAnnotationPresent("javax.persistence.AssociationOverrides")) {
            Object[] objectArray = this.getAnnotation("javax.persistence.AssociationOverrides").getAttributeArray("value");
            n = objectArray.length;
            int n4 = 0;
            while (n4 < n) {
                Object associationOverride = objectArray[n4];
                this.addAssociationOverride(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride, this));
                ++n4;
            }
        }
        if (this.isAnnotationPresent("javax.persistence.AssociationOverride")) {
            this.addAssociationOverride(new AssociationOverrideMetadata(this.getAnnotation("javax.persistence.AssociationOverride"), this));
        }
        if (this.isAnnotationPresent("javax.persistence.OrderColumn")) {
            this.m_orderColumn = new OrderColumnMetadata(this.getAnnotation("javax.persistence.OrderColumn"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.MapKeyEnumerated")) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata(this.getAnnotation("javax.persistence.MapKeyEnumerated"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.MapKeyTemporal")) {
            this.m_mapKeyTemporal = new TemporalMetadata(this.getAnnotation("javax.persistence.MapKeyTemporal"), this);
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = this.getAnnotation(MapKeyConvert.class).getAttributeString("value");
        }
        if (this.isAnnotationPresent(DeleteAll.class) && this.isPrivateOwned()) {
            this.m_deleteAll = Boolean.TRUE;
        }
    }

    protected void addAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (associationOverride.getName().startsWith("key.")) {
            associationOverride.setName(associationOverride.getName().substring("key.".length()));
        }
        this.m_mapKeyAssociationOverrides.add(associationOverride);
    }

    protected void addAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (attributeOverride.getName().startsWith("key.")) {
            attributeOverride.setName(attributeOverride.getName().substring("key.".length()));
        }
        this.m_mapKeyAttributeOverrides.add(attributeOverride);
    }

    @Override
    public void addMapKeyConvert(ConvertMetadata convert) {
        if (this.m_mapKeyConverts == null) {
            this.m_mapKeyConverts = new ArrayList<ConvertMetadata>();
        }
        this.m_mapKeyConverts.add(convert);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CollectionAccessor) {
            CollectionAccessor collectionAccessor = (CollectionAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_mapKeyColumn, collectionAccessor.getMapKeyColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyEnumerated, collectionAccessor.getMapKeyEnumerated())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAssociationOverrides, collectionAccessor.getMapKeyAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAttributeOverrides, collectionAccessor.getMapKeyAttributeOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyJoinColumns, collectionAccessor.getMapKeyJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyForeignKey, collectionAccessor.getMapKeyForeignKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKey, collectionAccessor.getMapKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderBy, collectionAccessor.getOrderBy())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderColumn, collectionAccessor.getOrderColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyConverts, collectionAccessor.getMapKeyConverts())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyClassName, collectionAccessor.getMapKeyClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_deleteAll, collectionAccessor.getDeleteAll())) {
                return false;
            }
            return this.valuesMatch(this.m_mapKeyTemporal, collectionAccessor.getMapKeyTemporal());
        }
        return false;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            if (this.m_mapKeyColumn == null) {
                return new ColumnMetadata(this.getAnnotation("javax.persistence.MapKeyColumn"), this);
            }
            return this.m_mapKeyColumn;
        }
        return super.getColumn(loggingCtx);
    }

    @Override
    public String getDefaultFetchType() {
        return "LAZY";
    }

    public Boolean getDeleteAll() {
        return this.m_deleteAll;
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return this.getMapKeyEnumerated();
    }

    @Override
    public MapKeyMetadata getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    @Override
    public MetadataClass getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public MetadataClass getMapKeyClassWithGenerics() {
        return this.getMapKeyClass();
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    @Override
    public List<ConvertMetadata> getMapKeyConverts() {
        return this.m_mapKeyConverts;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public ForeignKeyMetadata getMapKeyForeignKey() {
        return this.m_mapKeyForeignKey;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public OrderByMetadata getOrderBy() {
        return this.m_orderBy;
    }

    protected OrderColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass.isVoid()) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity((String)this.getAttributeName(), (Object)this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    protected DatabaseTable getReferenceDatabaseTable() {
        if (this.getMapping().isManyToManyMapping()) {
            return ((ManyToManyMapping)this.getMapping()).getRelationTable();
        }
        return super.getReferenceDatabaseTable();
    }

    @Override
    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return this.getMapKeyTemporal();
    }

    @Override
    public void setTemporal(TemporalMetadata metadata, boolean isForMapKey) {
        this.m_mapKeyTemporal = metadata;
    }

    @Override
    public boolean hasEnumerated(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyEnumerated != null : super.hasEnumerated(isForMapKey);
    }

    @Override
    public boolean hasMapKey() {
        return this.m_mapKey != null;
    }

    @Override
    public boolean hasTemporal(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyTemporal != null : super.hasTemporal(isForMapKey);
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    public boolean isDeleteAll() {
        return this.m_deleteAll != null && this.m_deleteAll != false;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_mapKeyConverts, accessibleObject);
        this.initXMLObjects(this.m_mapKeyJoinColumns, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, accessibleObject);
        this.initXMLObject(this.m_mapKey, accessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, accessibleObject);
        this.initXMLObject(this.m_orderBy, accessibleObject);
        this.initXMLObject(this.m_orderColumn, accessibleObject);
        this.initXMLObject(this.m_mapKeyForeignKey, accessibleObject);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
        this.m_mapKeyConvert = this.initXMLTextObject(this.m_mapKeyConverts);
    }

    @Override
    public void process() {
        super.process();
        if (!this.getAccessibleObject().isSupportedToManyCollectionClass(this.getRawClass())) {
            throw ValidationException.invalidCollectionTypeForRelationship((Object)this.getJavaClass(), (Object)this.getRawClass(), (Object)this.getAttributeName());
        }
    }

    protected void process(CollectionMapping mapping) {
        this.processRelationshipMapping((ForeignReferenceMapping)mapping);
        if (this.m_orderBy != null) {
            this.m_orderBy.process(mapping, this.getReferenceDescriptor(), this.getJavaClass());
        }
        if (this.m_orderColumn != null) {
            this.m_orderColumn.process(mapping, this.getDescriptor());
        }
        if (this.m_deleteAll != null && mapping.isPrivateOwned()) {
            mapping.setMustDeleteReferenceObjectsOneByOne(Boolean.valueOf(this.m_deleteAll == false));
        }
        this.processContainerPolicyAndIndirection((ContainerMapping)mapping);
        this.processReturnInsertAndUpdate();
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isManyToManyMapping()) {
            JoinTableMetadata joinTable = associationOverride.getJoinTable();
            String defaultName = String.valueOf(owningDescriptor.getPrimaryTableName()) + "_" + this.getReferenceDescriptor().getPrimaryTableName();
            this.processTable(joinTable, defaultName);
            ManyToManyMapping overrideMapping = new ManyToManyMapping();
            overrideMapping.setAttributeName(this.getAttributeName());
            this.processJoinTable((ForeignReferenceMapping)overrideMapping, overrideMapping.getRelationTableMechanism(), joinTable);
            embeddableMapping.addOverrideManyToManyMapping(overrideMapping);
            this.setOverrideMapping((DatabaseMapping)overrideMapping);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processEISOneToManyMapping(EISOneToManyMapping mapping) {
        String defaultFKFieldName = String.valueOf(this.getDefaultAttributeName()) + "_" + this.getReferenceDescriptor().getPrimaryKeyFieldName();
        List<JoinColumnMetadata> joinColumns = this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor());
        ForeignKeyMetadata foreignKey = this.getForeignKey(this.getForeignKey(), this.getReferenceDescriptor());
        this.processForeignKeyRelationship((ForeignReferenceMapping)mapping, joinColumns, foreignKey, this.getReferenceDescriptor(), defaultFKFieldName, this.getDescriptor().getPrimaryTable());
        if (this.getReferenceDescriptor().getPrimaryKeyFields().size() > 1) {
            mapping.setForeignKeyGroupingElement(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column"));
        }
    }

    public void setDeleteAll(Boolean deleteAll) {
        this.m_deleteAll = deleteAll;
    }

    public void setMapKey(MapKeyMetadata mapKey) {
        this.m_mapKey = mapKey;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> mapKeyAssociationOverrides) {
        this.m_mapKeyAssociationOverrides = mapKeyAssociationOverrides;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> mapKeyAttributeOverrides) {
        this.m_mapKeyAttributeOverrides = mapKeyAttributeOverrides;
    }

    @Override
    public void setMapKeyClass(MetadataClass mapKeyClass) {
        this.m_mapKeyClass = mapKeyClass;
    }

    public void setMapKeyClassName(String mapKeyClassName) {
        this.m_mapKeyClassName = mapKeyClassName;
    }

    public void setMapKeyColumn(ColumnMetadata mapKeyColumn) {
        this.m_mapKeyColumn = mapKeyColumn;
    }

    public void setMapKeyConverts(List<ConvertMetadata> mapKeyConverts) {
        this.m_mapKeyConverts = mapKeyConverts;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata mapKeyEnumerated) {
        this.m_mapKeyEnumerated = mapKeyEnumerated;
    }

    public void setMapKeyForeignKey(ForeignKeyMetadata mapKeyForeignKey) {
        this.m_mapKeyForeignKey = mapKeyForeignKey;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> mapKeyJoinColumns) {
        this.m_mapKeyJoinColumns = mapKeyJoinColumns;
    }

    public void setMapKeyTemporal(TemporalMetadata mapKeyTemporal) {
        this.m_mapKeyTemporal = mapKeyTemporal;
    }

    public void setOrderBy(OrderByMetadata orderBy) {
        this.m_orderBy = orderBy;
    }

    public void setOrderColumn(OrderColumnMetadata orderColumn) {
        this.m_orderColumn = orderColumn;
    }
}

