/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;

class QueryManager {
    private List fQueries;
    private List fListeners = new ArrayList();

    public QueryManager() {
        this.fQueries = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQueries() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            return !this.fQueries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            return this.fQueries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISearchQuery[] getQueries() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            return this.fQueries.toArray(new ISearchQuery[this.fQueries.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(ISearchQuery query) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            this.fQueries.remove(query);
        }
        this.fireRemoved(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(ISearchQuery query) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            if (this.fQueries.contains(query)) {
                return;
            }
            this.fQueries.add(0, query);
        }
        this.fireAdded(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryListener(IQueryListener l) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueryListener(IQueryListener l) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAdded(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryAdded(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRemoved(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryRemoved(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStarting(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryStarting(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFinished(ISearchQuery query) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            IQueryListener l = (IQueryListener)listeners.next();
            l.queryFinished(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            List old = this.fQueries;
            this.fQueries = new LinkedList();
            Iterator iter = old.iterator();
            while (iter.hasNext()) {
                ISearchQuery element = (ISearchQuery)iter.next();
                this.fireRemoved(element);
            }
        }
    }

    public void queryFinished(ISearchQuery query) {
        this.fireFinished(query);
    }

    public void queryStarting(ISearchQuery query) {
        this.fireStarting(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(ISearchQuery query) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            if (this.fQueries.contains(query)) {
                this.fQueries.remove(query);
                this.fQueries.add(0, query);
            }
        }
    }
}

