/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.model.event;

import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListEvent;

public final class ListMoveEvent
extends ListEvent {
    private final int targetIndex;
    private final int sourceIndex;
    private final int length;
    private static final long serialVersionUID = 1L;

    public ListMoveEvent(Model source, String listName, int targetIndex, int sourceIndex, int length) {
        super(source, listName);
        this.targetIndex = targetIndex;
        this.sourceIndex = sourceIndex;
        this.length = length;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getLength() {
        return this.length;
    }

    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        sb.append(this.sourceIndex);
        sb.append(" => ");
        sb.append(this.targetIndex);
        sb.append(" length=");
        sb.append(this.length);
    }

    public ListMoveEvent clone(Model newSource) {
        return this.clone(newSource, this.listName);
    }

    public ListMoveEvent clone(Model newSource, String newListName) {
        return this.clone(newSource, newListName, 0);
    }

    public ListMoveEvent clone(Model newSource, String newListName, int offset) {
        return new ListMoveEvent(newSource, newListName, this.targetIndex + offset, this.sourceIndex + offset, this.length);
    }
}

