/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.NullList;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCollectionValueModel<E1, E2>
extends CollectionValueModelWrapper<E1>
implements CollectionValueModel<E2> {
    private final Transformer<E1, ? extends CollectionValueModel<? extends E2>> transformer;
    private final IdentityHashMap<E1, CollectionValueModel<? extends E2>> componentCVMs = new IdentityHashMap();
    private final IdentityHashMap<CollectionValueModel<? extends E2>, ArrayList<E2>> collections = new IdentityHashMap();
    private final CollectionChangeListener componentCVMListener;
    private int size;

    public static <E1 extends CollectionValueModel<? extends E2>, E2> CompositeCollectionValueModel<E1, E2> forModels(ListValueModel<E1> listModel) {
        return CompositeCollectionValueModel.forModels(new ListCollectionValueModelAdapter<E1>(listModel));
    }

    public static <E1 extends CollectionValueModel<? extends E2>, E2> CompositeCollectionValueModel<E1, E2> forModels(Collection<E1> collection) {
        return CompositeCollectionValueModel.forModels(new StaticCollectionValueModel<E1>(collection));
    }

    public static <E1 extends CollectionValueModel<? extends E2>, E2> CompositeCollectionValueModel<E1, E2> forModels(E1 ... collection) {
        return CompositeCollectionValueModel.forModels(new StaticCollectionValueModel<E1>(collection));
    }

    public static <E1 extends CollectionValueModel<? extends E2>, E2> CompositeCollectionValueModel<E1, E2> forModels(CollectionValueModel<E1> collectionModel) {
        return new CompositeCollectionValueModel<E1, E2>(collectionModel, TransformerTools.passThruTransformer());
    }

    public CompositeCollectionValueModel(ListValueModel<? extends E1> listModel, Transformer<E1, ? extends CollectionValueModel<? extends E2>> transformer) {
        this(new ListCollectionValueModelAdapter<E1>(listModel), transformer);
    }

    public CompositeCollectionValueModel(Collection<? extends E1> collection, Transformer<E1, ? extends CollectionValueModel<? extends E2>> transformer) {
        this(new StaticCollectionValueModel<E1>(collection), transformer);
    }

    public CompositeCollectionValueModel(E1[] collection, Transformer<E1, ? extends CollectionValueModel<? extends E2>> transformer) {
        this(new StaticCollectionValueModel<E1>(collection), transformer);
    }

    public CompositeCollectionValueModel(CollectionValueModel<? extends E1> collectionModel, Transformer<E1, ? extends CollectionValueModel<? extends E2>> transformer) {
        super(collectionModel);
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
        this.componentCVMListener = this.buildComponentListener();
        this.size = 0;
    }

    protected CollectionChangeListener buildComponentListener() {
        return new ComponentListener();
    }

    @Override
    public Iterator<E2> iterator() {
        return this.buildCompositeIterable().iterator();
    }

    protected Iterable<E2> buildCompositeIterable() {
        return IterableTools.concatenate(this.collections.values());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.addAllComponentSources();
    }

    protected void addAllComponentSources() {
        for (Object source : this.collectionModel) {
            this.addComponentSource(source, NullList.instance());
        }
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        for (CollectionValueModel<E2> componentCVM : this.componentCVMs.values()) {
            componentCVM.removeCollectionChangeListener("values", this.componentCVMListener);
        }
        this.componentCVMs.clear();
        this.collections.clear();
        this.size = 0;
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        ArrayList addedItems = new ArrayList();
        for (Object item : this.getItems(event)) {
            this.addComponentSource(item, addedItems);
        }
        this.fireItemsAdded("values", addedItems);
    }

    protected void addComponentSource(E1 source, List<E2> addedItems) {
        CollectionValueModel<E2> componentCVM = this.transformer.transform(source);
        if (this.componentCVMs.put(source, componentCVM) != null) {
            throw new IllegalStateException("duplicate component: " + source);
        }
        componentCVM.addCollectionChangeListener("values", this.componentCVMListener);
        ArrayList componentCollection = new ArrayList(componentCVM.size());
        if (this.collections.put(componentCVM, componentCollection) != null) {
            throw new IllegalStateException("duplicate collection: " + source);
        }
        this.addComponentItems(componentCVM, componentCollection);
        addedItems.addAll(componentCollection);
    }

    protected void addComponentItems(CollectionValueModel<? extends E2> componentCVM, ArrayList<E2> componentCollection) {
        int itemsSize = componentCVM.size();
        this.size += itemsSize;
        componentCollection.ensureCapacity(componentCollection.size() + itemsSize);
        CollectionTools.addAll(componentCollection, componentCVM);
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        ArrayList removedItems = new ArrayList();
        for (Object item : this.getItems(event)) {
            this.removeComponentSource(item, removedItems);
        }
        this.fireItemsRemoved("values", removedItems);
    }

    protected void removeComponentSource(E1 source, List<E2> removedItems) {
        CollectionValueModel<E2> componentCVM = this.componentCVMs.remove(source);
        if (componentCVM == null) {
            throw new IllegalStateException("missing component: " + source);
        }
        componentCVM.removeCollectionChangeListener("values", this.componentCVMListener);
        ArrayList<E2> componentCollection = this.collections.remove(componentCVM);
        if (componentCollection == null) {
            throw new IllegalStateException("missing collection: " + source);
        }
        removedItems.addAll(componentCollection);
        this.removeComponentItems(componentCollection);
    }

    protected void removeComponentItems(ArrayList<E2> componentCollection) {
        this.size -= componentCollection.size();
        componentCollection.clear();
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.removeAllComponentSources();
        this.fireCollectionCleared("values");
    }

    protected void removeAllComponentSources() {
        ArrayList<E1> copy = new ArrayList<E1>(this.componentCVMs.keySet());
        for (E1 source : copy) {
            this.removeComponentSource(source, NullList.instance());
        }
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.removeAllComponentSources();
        this.addAllComponentSources();
        this.fireCollectionChanged("values", CollectionTools.collection(this.iterator()));
    }

    protected void componentItemsAdded(CollectionAddEvent event) {
        int itemsSize = event.getItemsSize();
        this.size += itemsSize;
        ArrayList<E2> componentCollection = this.collections.get(this.componentCVM(event));
        componentCollection.ensureCapacity(componentCollection.size() + itemsSize);
        this.addItemsToCollection(this.getComponentItems(event), componentCollection, "values");
    }

    protected void componentItemsRemoved(CollectionRemoveEvent event) {
        this.size -= event.getItemsSize();
        ArrayList<E2> componentCollection = this.collections.get(this.componentCVM(event));
        this.removeItemsFromCollection(this.getComponentItems(event), componentCollection, "values");
    }

    protected void componentCollectionCleared(CollectionClearEvent event) {
        ArrayList<E2> componentCollection = this.collections.get(this.componentCVM(event));
        ArrayList<E2> removedItems = new ArrayList<E2>(componentCollection);
        this.removeComponentItems(componentCollection);
        this.fireItemsRemoved("values", removedItems);
    }

    protected void componentCollectionChanged(CollectionChangeEvent event) {
        CollectionValueModel<E2> componentCVM = this.componentCVM(event);
        ArrayList<E2> componentCollection = this.collections.get(componentCVM);
        this.removeComponentItems(componentCollection);
        this.addComponentItems(componentCVM, componentCollection);
        this.fireCollectionChanged("values", CollectionTools.collection(this.iterator()));
    }

    protected Iterable<E2> getComponentItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E2> getComponentItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    protected CollectionValueModel<E2> componentCVM(CollectionEvent event) {
        return (CollectionValueModel)event.getSource();
    }

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }

    protected class ComponentListener
    extends CollectionChangeAdapter {
        protected ComponentListener() {
        }

        public void itemsAdded(CollectionAddEvent event) {
            CompositeCollectionValueModel.this.componentItemsAdded(event);
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            CompositeCollectionValueModel.this.componentItemsRemoved(event);
        }

        public void collectionCleared(CollectionClearEvent event) {
            CompositeCollectionValueModel.this.componentCollectionCleared(event);
        }

        public void collectionChanged(CollectionChangeEvent event) {
            CompositeCollectionValueModel.this.componentCollectionChanged(event);
        }
    }
}

