/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.internal.collection.EmptyBag;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.IdentityHashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTools {
    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(collection, iterable.iterator());
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.addAll(collection, iterable.iterator(), iterableSize);
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator) {
        return iterator.hasNext() && CollectionTools.addAll_(collection, iterator);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, Iterator<? extends E> iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.add(iterator.next());
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator, int iteratorSize) {
        return iterator.hasNext() && collection.addAll(ListTools.list(iterator, iteratorSize));
    }

    public static <E> boolean addAll(Collection<? super E> collection, E ... array) {
        return array.length != 0 && CollectionTools.addAll_(collection, array);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, E ... array) {
        boolean modified = false;
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            modified |= collection.add(element);
            ++n2;
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Queue<? extends E> queue) {
        return !queue.isEmpty() && CollectionTools.addAll_(collection, queue);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, Queue<? extends E> queue) {
        boolean modified = false;
        while (!queue.isEmpty()) {
            modified |= collection.add(queue.dequeue());
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Queue<? extends E> queue, int queueSize) {
        return !queue.isEmpty() && collection.addAll(ListTools.list(queue, queueSize));
    }

    public static <E> boolean addAll(Collection<? super E> collection, Stack<? extends E> stack) {
        return !stack.isEmpty() && CollectionTools.addAll_(collection, stack);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, Stack<? extends E> stack) {
        boolean modified = false;
        while (!stack.isEmpty()) {
            modified |= collection.add(stack.pop());
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Stack<? extends E> stack, int stackSize) {
        return !stack.isEmpty() && collection.addAll(ListTools.list(stack, stackSize));
    }

    public static boolean containsAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.containsAll(collection, iterable.iterator());
    }

    public static boolean containsAll(Collection<?> collection, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Object ... array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Queue<?> queue) {
        while (!queue.isEmpty()) {
            if (collection.contains(queue.dequeue())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Stack<?> stack) {
        while (!stack.isEmpty()) {
            if (collection.contains(stack.pop())) continue;
            return false;
        }
        return true;
    }

    public static <E> HashBag<E> filter(Collection<? extends E> collection, Predicate<? super E> filter) {
        HashBag<E> result = new HashBag<E>(collection.size());
        for (E e : collection) {
            if (!filter.evaluate(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> ArrayList<ArrayList<E>> partition(Collection<? extends E> collection, int count) {
        int j;
        ArrayList<E> partition;
        int i;
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than zero: " + count);
        }
        int collectionSize = collection.size();
        if (collectionSize < count) {
            throw new IllegalArgumentException("collection size (" + collectionSize + ") must be greater than or equal to count: " + count);
        }
        int partitionSize = collectionSize / count;
        int remainder = collectionSize % count;
        Iterator<E> stream = collection.iterator();
        ArrayList result = new ArrayList(count);
        if (remainder != 0) {
            ++partitionSize;
            i = remainder;
            while (i-- > 0) {
                partition = new ArrayList(partitionSize);
                j = partitionSize;
                while (j-- > 0) {
                    partition.add(stream.next());
                }
                result.add(partition);
            }
            --partitionSize;
            count -= remainder;
        }
        i = count;
        while (i-- > 0) {
            partition = new ArrayList<E>(partitionSize);
            j = partitionSize;
            while (j-- > 0) {
                partition.add(stream.next());
            }
            result.add(partition);
        }
        return result;
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.removeAll(collection, iterable.iterator());
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.removeAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator) {
        return iterator.hasNext() && collection.removeAll(CollectionTools.set(iterator));
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() && collection.removeAll(CollectionTools.set(iterator, iteratorSize));
    }

    public static boolean removeAll(Collection<?> collection, Object ... array) {
        return array.length != 0 && collection.removeAll(CollectionTools.set(array));
    }

    public static boolean removeAll(Collection<?> collection, Queue<?> queue) {
        return !queue.isEmpty() && collection.removeAll(CollectionTools.set(queue));
    }

    public static boolean removeAll(Collection<?> collection, Queue<?> queue, int queueSize) {
        return !queue.isEmpty() && collection.removeAll(CollectionTools.set(queue, queueSize));
    }

    public static boolean removeAll(Collection<?> collection, Stack<?> stack) {
        return !stack.isEmpty() && collection.removeAll(CollectionTools.set(stack));
    }

    public static boolean removeAll(Collection<?> collection, Stack<?> stack, int stackSize) {
        return !stack.isEmpty() && collection.removeAll(CollectionTools.set(stack, stackSize));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean removeAllOccurrences(Collection<?> collection, Object value) {
        block2: {
            modified = false;
            stream = collection.iterator();
            if (value != null) ** GOTO lbl13
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
lbl13:
                // 3 sources

                ** while (stream.hasNext())
            }
        }
        return modified;
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.retainAll(collection, iterable.iterator());
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.retainAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator, iteratorSize));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Object ... array) {
        if (array.length > 0) {
            return collection.retainAll(CollectionTools.set(array));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Queue<?> queue) {
        if (!queue.isEmpty()) {
            return collection.retainAll(CollectionTools.set(queue));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Queue<?> queue, int queueSize) {
        if (!queue.isEmpty()) {
            return collection.retainAll(CollectionTools.set(queue, queueSize));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Stack<?> stack) {
        if (!stack.isEmpty()) {
            return collection.retainAll(CollectionTools.set(stack));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Stack<?> stack, int stackSize) {
        if (!stack.isEmpty()) {
            return collection.retainAll(CollectionTools.set(stack, stackSize));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static <E1, E2> HashBag<E2> transform(Collection<E1> collection, Transformer<? super E1, ? extends E2> transformer) {
        HashBag<E2> result = new HashBag<E2>(collection.size());
        for (E1 e : collection) {
            result.add(transformer.transform(e));
        }
        return result;
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return CollectionTools.bag(iterable.iterator());
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.bag(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator, new HashBag());
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, new HashBag(iteratorSize));
    }

    private static <E> HashBag<E> bag(Iterator<? extends E> iterator, HashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> HashBag<E> bag(E ... array) {
        int len = array.length;
        HashBag<E> bag = new HashBag<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> HashBag<E> bag(Queue<? extends E> queue) {
        return CollectionTools.bag(queue, new HashBag());
    }

    public static <E> HashBag<E> bag(Queue<? extends E> queue, int queueSize) {
        return CollectionTools.bag(queue, new HashBag(queueSize));
    }

    private static <E> HashBag<E> bag(Queue<? extends E> queue, HashBag<E> set) {
        while (!queue.isEmpty()) {
            set.add(queue.dequeue());
        }
        return set;
    }

    public static <E> HashBag<E> bag(Stack<? extends E> stack) {
        return CollectionTools.bag(stack, new HashBag());
    }

    public static <E> HashBag<E> bag(Stack<? extends E> stack, int stackSize) {
        return CollectionTools.bag(stack, new HashBag(stackSize));
    }

    private static <E> HashBag<E> bag(Stack<? extends E> stack, HashBag<E> set) {
        while (!stack.isEmpty()) {
            set.add(stack.pop());
        }
        return set;
    }

    public static <E> Bag<E> emptyBag() {
        return EmptyBag.instance();
    }

    public static <E> IdentityHashBag<E> identityBag(Iterable<? extends E> iterable) {
        return CollectionTools.identityBag(iterable.iterator());
    }

    public static <E> IdentityHashBag<E> identityBag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.identityBag(iterable.iterator(), iterableSize);
    }

    public static <E> IdentityHashBag<E> identityBag(Iterator<? extends E> iterator) {
        return CollectionTools.identityBag(iterator, new IdentityHashBag());
    }

    public static <E> IdentityHashBag<E> identityBag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.identityBag(iterator, new IdentityHashBag(iteratorSize));
    }

    private static <E> IdentityHashBag<E> identityBag(Iterator<? extends E> iterator, IdentityHashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> IdentityHashBag<E> identityBag(E ... array) {
        int len = array.length;
        IdentityHashBag<E> bag = new IdentityHashBag<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable) {
        return CollectionTools.collection(iterable.iterator());
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.collection(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, iteratorSize);
    }

    public static <E> HashBag<E> collection(E ... array) {
        return CollectionTools.bag(array);
    }

    public static <E> HashBag<E> collection(Queue<? extends E> queue) {
        return CollectionTools.bag(queue);
    }

    public static <E> HashBag<E> collection(Queue<? extends E> queue, int queueSize) {
        return CollectionTools.bag(queue, queueSize);
    }

    public static <E> HashBag<E> collection(Stack<? extends E> stack) {
        return CollectionTools.bag(stack);
    }

    public static <E> HashBag<E> collection(Stack<? extends E> stack, int stackSize) {
        return CollectionTools.bag(stack, stackSize);
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable) {
        return CollectionTools.set(iterable.iterator());
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.set(iterable.iterator(), iterableSize);
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator) {
        return CollectionTools.set(iterator, new HashSet());
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.set(iterator, new HashSet(iteratorSize));
    }

    private static <E> HashSet<E> set(Iterator<? extends E> iterator, HashSet<E> set) {
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> HashSet<E> set(E ... array) {
        HashSet<E> set = new HashSet<E>(array.length);
        int i = array.length;
        while (i-- > 0) {
            set.add(array[i]);
        }
        return set;
    }

    public static <E> HashSet<E> set(Queue<? extends E> queue) {
        return CollectionTools.set(queue, new HashSet());
    }

    public static <E> HashSet<E> set(Queue<? extends E> queue, int queueSize) {
        return CollectionTools.set(queue, new HashSet(queueSize));
    }

    private static <E> HashSet<E> set(Queue<? extends E> queue, HashSet<E> set) {
        while (!queue.isEmpty()) {
            set.add(queue.dequeue());
        }
        return set;
    }

    public static <E> HashSet<E> set(Stack<? extends E> stack) {
        return CollectionTools.set(stack, new HashSet());
    }

    public static <E> HashSet<E> set(Stack<? extends E> stack, int stackSize) {
        return CollectionTools.set(stack, new HashSet(stackSize));
    }

    private static <E> HashSet<E> set(Stack<? extends E> stack, HashSet<E> set) {
        while (!stack.isEmpty()) {
            set.add(stack.pop());
        }
        return set;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable) {
        return CollectionTools.sortedSet(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.sortedSet(iterable.iterator(), iterableSize);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator, iterableSize);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.sortedSet(iterator, null, iteratorSize);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(ListTools.list(iterator), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return CollectionTools.sortedSet(ListTools.list(iterator, iteratorSize), comparator);
    }

    private static <E> TreeSet<E> sortedSet(List<E> list, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(list);
        return sortedSet;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(E ... array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static <E> TreeSet<E> sortedSet(E[] array, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static <E> TreeSet<E> sortedSet(Queue<? extends E> queue) {
        return CollectionTools.sortedSet(queue, null);
    }

    public static <E> TreeSet<E> sortedSet(Queue<? extends E> queue, int queueSize) {
        return CollectionTools.sortedSet(queue, null, queueSize);
    }

    public static <E> TreeSet<E> sortedSet(Queue<? extends E> queue, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(ListTools.list(queue), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Queue<? extends E> queue, Comparator<? super E> comparator, int queueSize) {
        return CollectionTools.sortedSet(ListTools.list(queue, queueSize), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Stack<? extends E> stack) {
        return CollectionTools.sortedSet(stack, null);
    }

    public static <E> TreeSet<E> sortedSet(Stack<? extends E> stack, int stackSize) {
        return CollectionTools.sortedSet(stack, null, stackSize);
    }

    public static <E> TreeSet<E> sortedSet(Stack<? extends E> stack, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(ListTools.list(stack), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Stack<? extends E> stack, Comparator<? super E> comparator, int stackSize) {
        return CollectionTools.sortedSet(ListTools.list(stack, stackSize), comparator);
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable) {
        return CollectionTools.vector(iterable.iterator());
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable, int size) {
        return CollectionTools.vector(iterable.iterator(), size);
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator) {
        return CollectionTools.vector(iterator, new Vector());
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator, int size) {
        return CollectionTools.vector(iterator, new Vector(size));
    }

    private static <E> Vector<E> vector(Iterator<? extends E> iterator, Vector<E> v) {
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static <E> Vector<E> vector(E ... array) {
        Vector<E> v = new Vector<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            v.addElement(item);
            ++n2;
        }
        return v;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

