/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultHistoryHelper;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.ui.ResultViewUIUtil;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultsViewLabelProvider
implements ITableLabelProvider {
    private static final String TAB = "\t";
    ResultsViewControl _resultsViewControl;

    public ResultsViewLabelProvider(ResultsViewControl resultsViewControl) {
        this._resultsViewControl = resultsViewControl;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            IResultInstance instance = (IResultInstance)element;
            int status = instance.getStatus();
            return ResultViewUIUtil.getOperationCommandStatusImage(status);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IResultInstance) {
            IResultInstance instance = (IResultInstance)element;
            int columnDisplayIndex = ResultHistoryHelper.getConfigurableColumnIndex(columnIndex, this._resultsViewControl.getUsePreferences());
            switch (columnDisplayIndex) {
                case 0: {
                    int status = instance.getStatus();
                    return OperationCommand.getStatusString((int)status);
                }
                case 1: {
                    return this.compact(instance.getOperationCommand());
                }
                case 2: {
                    return Integer.toString(instance.getFrequency());
                }
                case 3: {
                    return instance.getExecuteTime();
                }
                case 4: {
                    return OperationCommand.getActionString((int)instance.getOperationCommand().getActionType());
                }
                case 5: {
                    return instance.getOperationCommand().getConsumerName();
                }
                case 6: {
                    return instance.getOperationCommand().getProfileName();
                }
            }
            return "";
        }
        return Messages.ResultViewLabelProvider_unknown;
    }

    public String getConfigurableColumnText(Object element, int columnIndex) {
        if (element instanceof IResultInstance) {
            int columnDisplayIndex = ResultHistoryHelper.getConfigurableColumnIndex(columnIndex, this._resultsViewControl.getUsePreferences());
            IResultInstance instance = (IResultInstance)element;
            switch (columnDisplayIndex) {
                case 0: {
                    int status = instance.getStatus();
                    return OperationCommand.getStatusString((int)status);
                }
                case 1: {
                    return this.compact(instance.getOperationCommand());
                }
                case 2: {
                    return Integer.toString(instance.getFrequency());
                }
                case 3: {
                    return instance.getExecuteTime();
                }
                case 4: {
                    return OperationCommand.getActionString((int)instance.getOperationCommand().getActionType());
                }
                case 5: {
                    return instance.getOperationCommand().getConsumerName();
                }
                case 6: {
                    return instance.getOperationCommand().getProfileName();
                }
            }
            return "";
        }
        return Messages.ResultViewLabelProvider_unknown;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String compact(OperationCommand operation) {
        String r = operation.getDisplayString().replaceAll(System.getProperty("line.separator"), "  ");
        return r.replaceAll(TAB, " ");
    }
}

