/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.facets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.wtp.facets.AbstractFacetDetector;
import org.eclipse.m2e.wtp.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FacetDetectorExtensionReader {
    private static final Logger LOG = LoggerFactory.getLogger(FacetDetectorExtensionReader.class);
    private static final String EXTENSION_FACET_DETECTORS = "org.eclipse.m2e.wtp.facetDetectors";
    private static final Object ELEMENT_FACET_DETECTOR = "facetDetector";

    FacetDetectorExtensionReader() {
    }

    public static synchronized Map<String, List<AbstractFacetDetector>> readFacetDetectorExtensions() {
        HashMap<String, List<AbstractFacetDetector>> map = new HashMap<String, List<AbstractFacetDetector>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_FACET_DETECTORS);
        if (configuratorsExtensionPoint != null) {
            IExtension[] configuratorExtensions;
            IExtension[] iExtensionArray = configuratorExtensions = configuratorsExtensionPoint.getExtensions();
            int n = configuratorExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_FACET_DETECTOR)) {
                        try {
                            String facetId = element.getAttribute("facetId");
                            Object o = element.createExecutableExtension("class");
                            AbstractFacetDetector facetDetector = (AbstractFacetDetector)o;
                            ArrayList<AbstractFacetDetector> detectors = (ArrayList<AbstractFacetDetector>)map.get(facetId);
                            if (detectors == null) {
                                detectors = new ArrayList<AbstractFacetDetector>();
                                map.put(facetId, detectors);
                            }
                            detectors.add(facetDetector);
                        }
                        catch (CoreException ex) {
                            LOG.error(Messages.FacetDetectorExtensionReader_Error_Configuring_Facet_Detector, (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        for (List detectors : map.values()) {
            Collections.sort(detectors);
        }
        return map;
    }
}

