/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.wizards.Activator;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class FeatureProjectConfigurator
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        IFile featureFile = project.getFile("feature.xml");
        if (featureFile.exists()) {
            WorkspaceFeatureModel workspaceFeatureModel = new WorkspaceFeatureModel(featureFile);
            workspaceFeatureModel.load();
            return workspaceFeatureModel.isLoaded();
        }
        return featureFile.exists();
    }

    public IWizard getConfigurationWizard() {
        return null;
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        if (!PDE.hasFeatureNature((IProject)project)) {
            try {
                CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
            }
            catch (Exception ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.pde", ex.getMessage(), (Throwable)ex));
            }
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return container.getFile((IPath)new Path("feature.xml")).exists();
    }

    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }
}

