/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerConfParameter;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.internal.docker.core.DockerConfParameter;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;

public class DockerHostConfig
implements IDockerHostConfig {
    private final List<String> binds;
    private final String containerIDFile;
    private final List<IDockerConfParameter> lxcConf;
    private final boolean privileged;
    private final Map<String, List<IDockerPortBinding>> portBindings;
    private final List<String> links;
    private final boolean publishAllPorts;
    private final List<String> dns;
    private final List<String> dnsSearch;
    private final List<String> volumesFrom;
    private final String networkMode;

    public DockerHostConfig(HostConfig hostConfig) {
        this.binds = hostConfig.binds();
        this.containerIDFile = hostConfig.containerIDFile();
        this.lxcConf = new ArrayList<IDockerConfParameter>();
        if (hostConfig.lxcConf() != null) {
            for (HostConfig.LxcConfParameter lxcConfParameter : hostConfig.lxcConf()) {
                this.lxcConf.add(new DockerConfParameter(lxcConfParameter));
            }
        }
        this.privileged = hostConfig.privileged() != null ? hostConfig.privileged() : false;
        this.portBindings = new HashMap<String, List<IDockerPortBinding>>();
        if (hostConfig != null && hostConfig.portBindings() != null) {
            for (Map.Entry entry : hostConfig.portBindings().entrySet()) {
                ArrayList<DockerPortBinding> portBindings = new ArrayList<DockerPortBinding>();
                for (PortBinding portBinding : (List)entry.getValue()) {
                    portBindings.add(new DockerPortBinding(portBinding));
                }
                this.portBindings.put((String)entry.getKey(), portBindings);
            }
        }
        this.links = hostConfig.links();
        this.publishAllPorts = hostConfig.publishAllPorts() != null ? hostConfig.publishAllPorts() : false;
        this.dns = hostConfig.dns();
        this.dnsSearch = hostConfig.dnsSearch();
        this.volumesFrom = hostConfig.volumesFrom();
        this.networkMode = hostConfig.networkMode();
    }

    private DockerHostConfig(Builder builder) {
        this.binds = builder.binds;
        this.containerIDFile = builder.containerIDFile;
        this.lxcConf = builder.lxcConf;
        this.privileged = builder.privileged != null ? builder.privileged : false;
        this.portBindings = builder.portBindings;
        this.links = builder.links;
        this.publishAllPorts = builder.publishAllPorts != null ? builder.publishAllPorts : false;
        this.dns = builder.dns;
        this.dnsSearch = builder.dnsSearch;
        this.volumesFrom = builder.volumesFrom;
        this.networkMode = builder.networkMode;
    }

    @Override
    public List<String> binds() {
        return this.binds;
    }

    @Override
    public String containerIDFile() {
        return this.containerIDFile;
    }

    @Override
    public List<IDockerConfParameter> lxcConf() {
        return this.lxcConf;
    }

    @Override
    public boolean privileged() {
        return this.privileged;
    }

    @Override
    public Map<String, List<IDockerPortBinding>> portBindings() {
        return this.portBindings;
    }

    @Override
    public List<String> links() {
        return this.links;
    }

    @Override
    public boolean publishAllPorts() {
        return this.publishAllPorts;
    }

    @Override
    public List<String> dns() {
        return this.dns;
    }

    @Override
    public List<String> dnsSearch() {
        return this.dnsSearch;
    }

    @Override
    public List<String> volumesFrom() {
        return this.volumesFrom;
    }

    @Override
    public String networkMode() {
        return this.networkMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ DockerHostConfig(Builder builder, DockerHostConfig dockerHostConfig) {
        this(builder);
    }

    public static class Builder {
        private List<String> binds;
        private String containerIDFile;
        private List<IDockerConfParameter> lxcConf;
        private Boolean privileged;
        private Map<String, List<IDockerPortBinding>> portBindings;
        private List<String> links;
        private Boolean publishAllPorts;
        private List<String> dns;
        private List<String> dnsSearch;
        private List<String> volumesFrom;
        private String networkMode;

        public Builder binds(List<String> binds) {
            this.binds = new ArrayList<String>(binds);
            return this;
        }

        public Builder binds(String ... binds) {
            this.binds = Arrays.asList(binds);
            return this;
        }

        public List<String> binds() {
            return this.binds;
        }

        public Builder containerIDFile(String containerIDFile) {
            this.containerIDFile = containerIDFile;
            return this;
        }

        public String containerIDFile() {
            return this.containerIDFile;
        }

        public Builder lxcConf(List<IDockerConfParameter> lxcConf) {
            this.lxcConf = new ArrayList<IDockerConfParameter>(lxcConf);
            return this;
        }

        public Builder lxcConf(IDockerConfParameter ... lxcConf) {
            this.lxcConf = Arrays.asList(lxcConf);
            return this;
        }

        public List<IDockerConfParameter> lxcConf() {
            return this.lxcConf;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Boolean privileged() {
            return this.privileged;
        }

        public Builder portBindings(Map<String, List<IDockerPortBinding>> portBindings) {
            this.portBindings = portBindings;
            return this;
        }

        public Map<String, List<IDockerPortBinding>> portBindings() {
            return this.portBindings;
        }

        public Builder links(List<String> links) {
            this.links = new ArrayList<String>(links);
            return this;
        }

        public Builder links(String ... links) {
            this.links = Arrays.asList(links);
            return this;
        }

        public List<String> links() {
            return this.links;
        }

        public Builder publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Boolean publishAllPorts() {
            return this.publishAllPorts;
        }

        public Builder dns(List<String> dns) {
            this.dns = new ArrayList<String>(dns);
            return this;
        }

        public Builder dns(String ... dns) {
            this.dns = Arrays.asList(dns);
            return this;
        }

        public List<String> dns() {
            return this.dns;
        }

        public Builder dnsSearch(List<String> dnsSearch) {
            this.dnsSearch = new ArrayList<String>(dnsSearch);
            return this;
        }

        public Builder dnsSearch(String ... dnsSearch) {
            this.dnsSearch = Arrays.asList(dnsSearch);
            return this;
        }

        public List<String> dnsSearch() {
            return this.dnsSearch;
        }

        public Builder volumesFrom(List<String> volumesFrom) {
            this.volumesFrom = new ArrayList<String>(volumesFrom);
            return this;
        }

        public Builder volumesFrom(String ... volumesFrom) {
            this.volumesFrom = Arrays.asList(volumesFrom);
            return this;
        }

        public List<String> volumesFrom() {
            return this.volumesFrom;
        }

        public Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public String networkMode() {
            return this.networkMode;
        }

        public IDockerHostConfig build() {
            return new DockerHostConfig(this, null);
        }
    }
}

