/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.Version;
import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;

public class DockerConnectionInfo
implements IDockerConnectionInfo {
    private final int containers;
    private final boolean debug;
    private final String executionDriver;
    private final int fileDescriptors;
    private final int goroutines;
    private final int images;
    private final String initPath;
    private final String kernelVersion;
    private final boolean memoryLimit;
    private final String storageDriver;
    private final boolean swapLimit;
    private final String apiVersion;
    private final String gitCommit;
    private final String os;
    private final String version;
    private final List<List<String>> driverStatus;
    private final int cpuNumber;
    private final long totalMemory;
    private final String name;
    private final String id;
    private final String initSha1;
    private final String indexServerAddress;
    private final boolean ipv4Forwarding;
    private final List<String> labels;
    private final String dockerRootDir;

    public DockerConnectionInfo(Info info, Version version) {
        this.containers = info.containers();
        this.debug = info.debug();
        this.executionDriver = info.executionDriver();
        this.fileDescriptors = info.fileDescriptors();
        this.goroutines = info.goroutines();
        this.images = info.images();
        this.initPath = info.initPath();
        this.kernelVersion = info.kernelVersion();
        this.memoryLimit = info.memoryLimit();
        this.storageDriver = info.storageDriver();
        this.swapLimit = info.swapLimit();
        this.apiVersion = version.apiVersion();
        this.gitCommit = version.gitCommit();
        this.os = version.os();
        this.version = version.version();
        this.driverStatus = info.driverStatus();
        this.cpuNumber = info.cpus();
        this.totalMemory = info.memTotal();
        this.name = info.name();
        this.id = info.id();
        this.initSha1 = info.initSha1();
        this.ipv4Forwarding = info.ipv4Forwarding();
        this.indexServerAddress = info.indexServerAddress();
        this.labels = info.labels();
        this.dockerRootDir = info.dockerRootDir();
    }

    @Override
    public boolean isMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public int getContainers() {
        return this.containers;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public String getExecutionDriver() {
        return this.executionDriver;
    }

    @Override
    public int getFileDescriptors() {
        return this.fileDescriptors;
    }

    @Override
    public int getGoroutines() {
        return this.goroutines;
    }

    @Override
    public int getImages() {
        return this.images;
    }

    @Override
    public String getInitPath() {
        return this.initPath;
    }

    @Override
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public String getStorageDriver() {
        return this.storageDriver;
    }

    @Override
    public boolean isSwapLimit() {
        return this.swapLimit;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public List<List<String>> getDriverStatus() {
        return this.driverStatus;
    }

    @Override
    public int getCPUNumber() {
        return this.cpuNumber;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInitSha1() {
        return this.initSha1;
    }

    @Override
    public String getIndexServerAddress() {
        return this.indexServerAddress;
    }

    @Override
    public boolean isIPv4Forwarding() {
        return this.ipv4Forwarding;
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public String getDockerRootDir() {
        return this.dockerRootDir;
    }
}

