/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificateException;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.Version;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerContainerNotFoundException;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConfParameter;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.ILogger;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.AbstractKillableThread;
import org.eclipse.linuxtools.internal.docker.core.DockerConnectionInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerExit;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerImageInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.core.DockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.HttpHijackWorkaround;
import org.eclipse.osgi.util.NLS;

public class DockerConnection
implements IDockerConnection,
Closeable {
    private final String name;
    private final String socketPath;
    private final String tcpHost;
    private final String tcpCertPath;
    private final String username;
    private final Object imageLock = new Object();
    private final Object containerLock = new Object();
    private final Object actionLock = new Object();
    private final Object clientLock = new Object();
    private DefaultDockerClient client;
    private Map<String, Job> actionJobs;
    private Map<String, LogThread> loggingThreads = new HashMap<String, LogThread>();
    private List<IDockerContainer> containers;
    private boolean containersLoaded = false;
    private List<IDockerImage> images;
    private boolean imagesLoaded = false;
    ListenerList containerListeners;
    ListenerList imageListeners;

    private DockerConnection(String name, String socketPath, String username, String password) {
        this.name = name;
        this.socketPath = socketPath;
        this.username = username;
        this.tcpHost = null;
        this.tcpCertPath = null;
        this.storePassword(socketPath, username, password);
    }

    private DockerConnection(String name, String tcpHost, String tcpCertPath, String username, String password) {
        this.name = name;
        this.socketPath = null;
        this.username = username;
        this.tcpHost = tcpHost;
        this.tcpCertPath = tcpCertPath;
        this.storePassword(this.socketPath, username, password);
        DockerContainerRefreshManager dcrm = DockerContainerRefreshManager.getInstance();
        this.addContainerListener(dcrm);
    }

    private void storePassword(String uri, String username, String passwd) {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        String key = DockerConnection.getPreferencesKey(uri, username);
        ISecurePreferences node = root.node(key);
        try {
            if (passwd != null && !passwd.equals("")) {
                node.put("password", passwd, true);
            }
        }
        catch (StorageException e) {
            Activator.log(e);
        }
    }

    public static String getPreferencesKey(String uri, String username) {
        String key = "/org/eclipse/linuxtools/docker/core/";
        key = String.valueOf(key) + uri + "/" + username;
        return EncodingUtils.encodeSlashes((String)key);
    }

    @Override
    public boolean isOpen() {
        return this.client != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(boolean registerContainerRefreshManager) throws DockerException {
        DockerConnection dockerConnection = this;
        synchronized (dockerConnection) {
            try {
                if (this.client == null) {
                    if (this.socketPath != null) {
                        this.client = DefaultDockerClient.builder().uri(this.socketPath).build();
                    } else if (this.tcpHost != null) {
                        this.client = this.tcpCertPath != null ? DefaultDockerClient.builder().uri(URI.create(this.tcpHost)).dockerCertificates(new DockerCertificates(new File(this.tcpCertPath).toPath())).build() : DefaultDockerClient.builder().uri(URI.create(this.tcpHost)).build();
                    }
                    if (registerContainerRefreshManager) {
                        DockerContainerRefreshManager dcrm = DockerContainerRefreshManager.getInstance();
                        this.addContainerListener(dcrm);
                    }
                }
            }
            catch (DockerCertificateException e) {
                throw new DockerException(Messages.Open_Connection_Failure, e);
            }
        }
    }

    @Override
    public void ping() throws DockerException {
        try {
            if (this.client == null) {
                throw new DockerException(Messages.Docker_Daemon_Ping_Failure);
            }
            this.client.ping();
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(Messages.Docker_Daemon_Ping_Failure, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    @Override
    public IDockerConnectionInfo getInfo() throws DockerException {
        try {
            Info info = this.client.info();
            Version version = this.client.version();
            return new DockerConnectionInfo(info, version);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(Messages.Docker_General_Info_Failure, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUri() {
        return this.socketPath != null ? this.socketPath : this.tcpHost;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void addContainerListener(IDockerContainerListener listener) {
        if (this.containerListeners == null) {
            this.containerListeners = new ListenerList(1);
        }
        this.containerListeners.add((Object)listener);
    }

    @Override
    public void removeContainerListener(IDockerContainerListener listener) {
        if (this.containerListeners != null) {
            this.containerListeners.remove((Object)listener);
        }
    }

    private DockerClient getClientCopy() throws DockerException {
        if (this.socketPath != null) {
            return DefaultDockerClient.builder().uri(this.socketPath).build();
        }
        if (this.tcpHost != null) {
            if (this.tcpCertPath != null) {
                try {
                    return DefaultDockerClient.builder().uri(URI.create(this.tcpHost)).dockerCertificates(new DockerCertificates(new File(this.tcpCertPath).toPath())).build();
                }
                catch (DockerCertificateException e) {
                    throw new DockerException(Messages.Retrieve_Docker_Certificates_Failure, e);
                }
            }
            return DefaultDockerClient.builder().uri(URI.create(this.tcpHost)).build();
        }
        throw new DockerException(Messages.Missing_Settings);
    }

    public void notifyContainerListeners(List<IDockerContainer> list) {
        if (this.containerListeners != null) {
            Object[] listeners = this.containerListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDockerContainerListener)listeners[i]).listChanged(this, list);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getActionJob(String id) {
        Object object = this.actionLock;
        synchronized (object) {
            Job j = null;
            if (this.actionJobs != null) {
                return this.actionJobs.get(id);
            }
            return j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActionJob(String id, Job j) {
        Object object = this.actionLock;
        synchronized (object) {
            if (this.actionJobs == null) {
                this.actionJobs = new HashMap<String, Job>();
            }
            this.actionJobs.put(id, j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionJob(String id, Job j) {
        Object object = this.actionLock;
        synchronized (object) {
            if (this.actionJobs != null && this.actionJobs.get(id) == j) {
                this.actionJobs.remove(id);
            }
        }
    }

    @Override
    public List<IDockerContainer> getContainers() {
        return this.getContainers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDockerContainer> getContainers(boolean force) {
        List<IDockerContainer> latestContainers;
        Object object = this.containerLock;
        synchronized (object) {
            latestContainers = this.containers;
        }
        if (!this.isContainersLoaded() || force) {
            try {
                try {
                    latestContainers = this.listContainers();
                }
                catch (DockerException e) {
                    Object object2 = this.containerLock;
                    synchronized (object2) {
                        this.containers = Collections.emptyList();
                    }
                    Activator.log(e);
                    this.containersLoaded = true;
                }
            }
            finally {
                this.containersLoaded = true;
            }
        }
        return latestContainers;
    }

    @Override
    public boolean isContainersLoaded() {
        return this.containersLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IDockerContainer> listContainers() throws DockerException {
        ArrayList<IDockerContainer> dclist = new ArrayList<IDockerContainer>();
        Object object = this.containerLock;
        synchronized (object) {
            List list = null;
            try {
                Object object2 = this.clientLock;
                synchronized (object2) {
                    if (this.client == null) {
                        return dclist;
                    }
                    list = this.client.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers()});
                }
            }
            catch (com.spotify.docker.client.DockerException | InterruptedException e) {
                throw new DockerException(NLS.bind((String)Messages.List_Docker_Containers_Failure, (Object)this.getName()), e);
            }
            for (Container c : list) {
                if (c.status().startsWith(Messages.Exited_specifier) && this.loggingThreads.containsKey(c.id())) {
                    this.loggingThreads.get(c.id()).requestStop();
                    this.loggingThreads.remove(c.id());
                }
                dclist.add(new DockerContainer(this, c));
            }
            this.containers = dclist;
        }
        this.notifyContainerListeners(dclist);
        return dclist;
    }

    @Override
    public IDockerContainer getContainer(String id) {
        List<IDockerContainer> containers = this.getContainers();
        for (IDockerContainer container : containers) {
            if (!container.id().equals(id)) continue;
            return container;
        }
        return null;
    }

    @Override
    public IDockerContainerInfo getContainerInfo(String id) {
        try {
            ContainerInfo info = this.client.inspectContainer(id);
            return new DockerContainerInfo(info);
        }
        catch (DockerRequestException e) {
            Activator.logErrorMessage(e.message());
            return null;
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", "Failed to inspect container '" + id + "'", e));
            return null;
        }
    }

    @Override
    public IDockerImageInfo getImageInfo(String id) {
        try {
            ImageInfo info = this.client.inspectImage(id);
            return new DockerImageInfo(info);
        }
        catch (DockerRequestException e) {
            Activator.logErrorMessage(e.message());
            return null;
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", "Failed to inspect container '" + id + "'", e));
            return null;
        }
    }

    @Override
    public void addImageListener(IDockerImageListener listener) {
        if (this.imageListeners == null) {
            this.imageListeners = new ListenerList(1);
        }
        this.imageListeners.add((Object)listener);
    }

    @Override
    public void removeImageListener(IDockerImageListener listener) {
        if (this.imageListeners != null) {
            this.imageListeners.remove((Object)listener);
        }
    }

    public void notifyImageListeners(List<IDockerImage> list) {
        if (this.imageListeners != null) {
            Object[] listeners = this.imageListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDockerImageListener)listeners[i]).listChanged(this, list);
                ++i;
            }
        }
    }

    @Override
    public List<IDockerImage> getImages() {
        return this.getImages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDockerImage> getImages(boolean force) {
        List<IDockerImage> latestImages;
        Object object = this.imageLock;
        synchronized (object) {
            latestImages = this.images;
        }
        if (!this.isImagesLoaded() || force) {
            try {
                try {
                    latestImages = this.listImages();
                }
                catch (DockerException e) {
                    Object object2 = this.imageLock;
                    synchronized (object2) {
                        this.images = Collections.emptyList();
                    }
                    Activator.log(e);
                    this.imagesLoaded = true;
                }
            }
            finally {
                this.imagesLoaded = true;
            }
        }
        return latestImages;
    }

    @Override
    public boolean isImagesLoaded() {
        return this.imagesLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDockerImage> listImages() throws DockerException {
        ArrayList<IDockerImage> dilist = new ArrayList<IDockerImage>();
        Object object = this.imageLock;
        synchronized (object) {
            List rawImages = null;
            try {
                Object object2 = this.clientLock;
                synchronized (object2) {
                    if (this.client == null) {
                        return dilist;
                    }
                    rawImages = this.client.listImages(new DockerClient.ListImagesParam[]{DockerClient.ListImagesParam.allImages()});
                }
            }
            catch (DockerRequestException e) {
                throw new DockerException(e.message());
            }
            catch (com.spotify.docker.client.DockerException | InterruptedException e) {
                DockerException f = new DockerException(e);
                throw f;
            }
            HashSet<String> imageParentIds = new HashSet<String>();
            for (Image rawImage : rawImages) {
                imageParentIds.add(rawImage.parentId());
            }
            for (Image rawImage : rawImages) {
                boolean taggedImage = rawImage.repoTags().size() != 1 || !rawImage.repoTags().contains((Object)"<none>:<none>");
                boolean intermediateImage = !taggedImage && imageParentIds.contains(rawImage.id());
                boolean danglingImage = !taggedImage && !intermediateImage;
                Map<String, List<String>> repoTags = DockerImage.extractTagsByRepo((List<String>)rawImage.repoTags());
                for (Map.Entry<String, List<String>> entry : repoTags.entrySet()) {
                    String repo = entry.getKey();
                    List<String> tags = entry.getValue();
                    dilist.add(new DockerImage(this, (List<String>)rawImage.repoTags(), repo, tags, rawImage.id(), rawImage.parentId(), rawImage.created(), rawImage.size(), rawImage.virtualSize(), intermediateImage, danglingImage));
                }
            }
            this.images = dilist;
        }
        this.notifyImageListeners(dilist);
        return dilist;
    }

    @Override
    public boolean hasImage(String repository, String tag) {
        for (IDockerImage image : this.getImages()) {
            if (!image.repo().equals(repository)) continue;
            for (String imageTag : image.tags()) {
                if (!imageTag.startsWith(tag)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pullImage(String id, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            this.client.pull(id, (ProgressHandler)d);
            this.listImages();
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public List<IDockerImageSearchResult> searchImages(String term) throws DockerException {
        try {
            List searchResults = this.client.searchImages(term);
            ArrayList<IDockerImageSearchResult> results = new ArrayList<IDockerImageSearchResult>();
            for (ImageSearchResult r : searchResults) {
                results.add(new DockerImageSearchResult(r.getDescription(), r.isOfficial(), r.isAutomated(), r.getName(), r.getStarCount()));
            }
            return results;
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void pushImage(String name, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            this.client.push(name, (ProgressHandler)d);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void removeImage(String name) throws DockerException, InterruptedException {
        try {
            this.client.removeImage(name, true, false);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void removeTag(String tag) throws DockerException, InterruptedException {
        try {
            this.client.removeImage(tag, false, false);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void tagImage(String name, String newTag) throws DockerException, InterruptedException {
        try {
            this.client.tag(name, newTag);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public String buildImage(IPath path, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            return this.client.build(p, (ProgressHandler)d, new DockerClient.BuildParameter[]{DockerClient.BuildParameter.FORCE_RM});
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public String buildImage(IPath path, String name, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            return this.client.build(p, name, (ProgressHandler)d, new DockerClient.BuildParameter[]{DockerClient.BuildParameter.FORCE_RM});
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    public void save() {
        DockerConnectionManager.getInstance().saveConnections();
    }

    @Override
    @Deprecated
    public String createContainer(IDockerContainerConfig c) throws DockerException, InterruptedException {
        DockerHostConfig hc = new DockerHostConfig(HostConfig.builder().build());
        return this.createContainer(c, hc);
    }

    @Override
    @Deprecated
    public String createContainer(IDockerContainerConfig c, String containerName) throws DockerException, InterruptedException {
        DockerHostConfig hc = new DockerHostConfig(HostConfig.builder().build());
        return this.createContainer(c, hc, containerName);
    }

    @Override
    public String createContainer(IDockerContainerConfig c, IDockerHostConfig hc) throws DockerException, InterruptedException {
        return this.createContainer(c, hc, null);
    }

    @Override
    public String createContainer(IDockerContainerConfig c, IDockerHostConfig hc, String containerName) throws DockerException, InterruptedException {
        try {
            HostConfig.Builder hbuilder = HostConfig.builder().containerIDFile(hc.containerIDFile()).publishAllPorts(Boolean.valueOf(hc.publishAllPorts())).privileged(Boolean.valueOf(hc.privileged())).networkMode(hc.networkMode());
            if (hc.binds() != null) {
                hbuilder.binds(hc.binds());
            }
            if (hc.dns() != null) {
                hbuilder.dns(hc.dns());
            }
            if (hc.dnsSearch() != null) {
                hbuilder.dnsSearch(hc.dnsSearch());
            }
            if (hc.links() != null) {
                hbuilder.links(hc.links());
            }
            if (hc.lxcConf() != null) {
                List<IDockerConfParameter> lxcconf = hc.lxcConf();
                ArrayList<HostConfig.LxcConfParameter> lxcreal = new ArrayList<HostConfig.LxcConfParameter>();
                for (IDockerConfParameter iDockerConfParameter : lxcconf) {
                    lxcreal.add(new HostConfig.LxcConfParameter(iDockerConfParameter.key(), iDockerConfParameter.value()));
                }
                hbuilder.lxcConf(lxcreal);
            }
            if (hc.portBindings() != null) {
                Map<String, List<IDockerPortBinding>> bindings = hc.portBindings();
                HashMap realBindings = new HashMap();
                for (Map.Entry entry : bindings.entrySet()) {
                    String key = (String)entry.getKey();
                    List bindingList = (List)entry.getValue();
                    ArrayList<PortBinding> newList = new ArrayList<PortBinding>();
                    for (IDockerPortBinding binding : bindingList) {
                        newList.add(PortBinding.of((String)binding.hostIp(), (String)binding.hostPort()));
                    }
                    realBindings.put(key, newList);
                }
                hbuilder.portBindings(realBindings);
            }
            if (hc.volumesFrom() != null) {
                hbuilder.volumesFrom(hc.volumesFrom());
            }
            ContainerConfig.Builder builder = ContainerConfig.builder().hostname(c.hostname()).domainname(c.domainname()).user(c.user()).memory(c.memory()).memorySwap(c.memorySwap()).cpuShares(c.cpuShares()).cpuset(c.cpuset()).attachStdin(Boolean.valueOf(c.attachStdin())).attachStdout(Boolean.valueOf(c.attachStdout())).attachStderr(Boolean.valueOf(c.attachStderr())).tty(Boolean.valueOf(c.tty())).openStdin(Boolean.valueOf(c.openStdin())).stdinOnce(Boolean.valueOf(c.stdinOnce())).cmd(c.cmd()).image(c.image()).hostConfig(hbuilder.build()).workingDir(c.workingDir()).networkDisabled(Boolean.valueOf(c.networkDisabled()));
            if (c.portSpecs() != null) {
                builder = builder.portSpecs(c.portSpecs());
            }
            if (c.exposedPorts() != null) {
                builder = builder.exposedPorts(c.exposedPorts());
            }
            if (c.env() != null) {
                builder = builder.env(c.env());
            }
            if (c.volumes() != null) {
                builder = builder.volumes(c.volumes());
            }
            if (c.entrypoint() != null) {
                builder = builder.entrypoint(c.entrypoint());
            }
            if (c.onBuild() != null) {
                builder = builder.onBuild(c.onBuild());
            }
            ContainerCreation creation = this.client.createContainer(builder.build(), containerName);
            String string = creation.id();
            this.listContainers();
            return string;
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.stopContainer(id, 10);
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                if (this.loggingThreads.containsKey(id)) {
                    this.loggingThreads.get(id).kill();
                    this.loggingThreads.remove(id);
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.killContainer(id);
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                if (this.loggingThreads.containsKey(id)) {
                    this.loggingThreads.get(id).kill();
                    this.loggingThreads.remove(id);
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void pauseContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.pauseContainer(id);
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpauseContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.unpauseContainer(id);
            if (stream != null) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    } else {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void removeContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.removeContainer(id);
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    @Deprecated
    public void startContainer(String id, IDockerHostConfig config, OutputStream stream) throws DockerException, InterruptedException {
        this.startContainer(id, stream);
    }

    @Override
    @Deprecated
    public void startContainer(String id, String loggingId, IDockerHostConfig config, OutputStream stream) throws DockerException, InterruptedException {
        this.startContainer(id, loggingId, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.startContainer(id);
            if (stream != null && !this.getContainerInfo(id).config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContainer(String id, String loggingId, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.startContainer(id);
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
            boolean autoLog = preferences.getBoolean("autoLogOnStart", true);
            if (autoLog && !this.getContainerInfo(id).config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(loggingId);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(loggingId, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void commitContainer(String id, String repo, String tag, String comment, String author) throws DockerException {
        try {
            ContainerInfo info = this.client.inspectContainer(id);
            this.client.commitContainer(id, repo, tag, info.config(), comment, author);
            this.listImages();
            this.getImages(true);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumDockerLoggingStatus loggingStatus(String id) {
        Map<String, LogThread> map = this.loggingThreads;
        synchronized (map) {
            LogThread t = this.loggingThreads.get(id);
            if (t == null) {
                return EnumDockerLoggingStatus.LOGGING_NONE;
            }
            if (t.isAlive()) {
                return EnumDockerLoggingStatus.LOGGING_ACTIVE;
            }
            return EnumDockerLoggingStatus.LOGGING_COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLoggingThread(String id) {
        Map<String, LogThread> map = this.loggingThreads;
        synchronized (map) {
            LogThread t = this.loggingThreads.get(id);
            if (t != null) {
                t.requestStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                ContainerInfo info = this.client.inspectContainer(id);
                LogThread t = this.loggingThreads.get(id);
                if (t == null || !t.isAlive()) {
                    t = new LogThread(id, this.getClientCopy(), info.state().running());
                    this.loggingThreads.put(id, t);
                    t.setOutputStream(stream);
                    t.start();
                } else {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public IDockerContainerExit waitForContainer(String id) throws DockerException, InterruptedException {
        try {
            DockerClient copy = this.getClientCopy();
            ContainerExit x = copy.waitContainer(id);
            DockerContainerExit exit = new DockerContainerExit(x.statusCode());
            this.listContainers();
            copy.close();
            return exit;
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public WritableByteChannel attachCommand(final String id, final InputStream in, final OutputStream out) throws DockerException {
        final byte[] prevCmd = new byte[1024];
        try {
            final LogStream pty_stream = this.client.attachContainer(id, new DockerClient.AttachParameter[]{DockerClient.AttachParameter.STDIN, DockerClient.AttachParameter.STDOUT, DockerClient.AttachParameter.STDERR, DockerClient.AttachParameter.STREAM, DockerClient.AttachParameter.LOGS});
            final boolean isTtyEnabled = this.getContainerInfo(id).config().tty();
            Thread t_in = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    byte[] buff = new byte[1024];
                    try {
                        WritableByteChannel pty_out = HttpHijackWorkaround.getOutputStream(pty_stream, DockerConnection.this.getUri());
                        while (true) {
                            int n = in.read(buff);
                            if (n == -1) return;
                            if (!DockerConnection.this.getContainerInfo(id).state().running().booleanValue()) {
                                return;
                            }
                            byte[] byArray = prevCmd;
                            // MONITORENTER : prevCmd
                            pty_out.write(ByteBuffer.wrap(buff, 0, n));
                            int i = 0;
                            while (true) {
                                if (i >= prevCmd.length) {
                                    // MONITOREXIT : byArray
                                    break;
                                }
                                prevCmd[i] = buff[i];
                                ++i;
                            }
                            buff = new byte[1024];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            t_in.start();
            Thread t_out = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        InputStream pty_in = HttpHijackWorkaround.getInputStream(pty_stream);
                        while (true) {
                            if (!DockerConnection.this.getContainerInfo(id).state().running().booleanValue()) {
                                return;
                            }
                            byte[] buff = new byte[1024];
                            int n = pty_in.read(buff);
                            if (n <= 0) continue;
                            if (isTtyEnabled) {
                                int idex = 0;
                                byte[] byArray = prevCmd;
                                // MONITORENTER : prevCmd
                                int i = 0;
                                while (i < prevCmd.length) {
                                    if (prevCmd[i] != buff[i] && prevCmd[i] != 10 && buff[i] != 13 && prevCmd[i] != 13 && buff[i] != 10 && prevCmd[i] != 0) {
                                        idex = 0;
                                        break;
                                    }
                                    if (prevCmd[i] != 0) {
                                        ++idex;
                                    }
                                    ++i;
                                }
                                // MONITOREXIT : byArray
                                if (idex != 0) {
                                    DockerConnection.shiftLeft(buff, idex + 1);
                                }
                                n = DockerConnection.removeTerminalCodes(buff);
                            } else {
                                DockerConnection.shiftLeft(buff, 8);
                                n -= 8;
                            }
                            out.write(buff, 0, n);
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof SocketTimeoutException)) return;
                        try {
                            DockerConnection.this.attachCommand(id, in, out);
                            return;
                        }
                        catch (DockerException dockerException) {
                            // empty catch block
                        }
                    }
                }
            });
            if (isTtyEnabled) {
                t_out.start();
            }
            return HttpHijackWorkaround.getOutputStream(pty_stream, this.getUri());
        }
        catch (Exception e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    private static int removeTerminalCodes(byte[] buff) {
        String tmp = new String(buff);
        byte[] tmp_buff = tmp.replaceAll("\u001b]0;.*\u0007", "").replaceAll("\u001b\\[([0-9]{1,2}(;[0-9]{1,2})?)?[mK]", "").replaceAll("\u001b\\[\\?[0-9]{1,4}h\\[", "").getBytes();
        int i = 0;
        while (i < buff.length) {
            buff[i] = i >= tmp_buff.length ? (byte)0 : tmp_buff[i];
            ++i;
        }
        return DockerConnection.getByteLength(buff);
    }

    private static void shiftLeft(byte[] buff, int idex) {
        int i = 0;
        while (i < buff.length) {
            buff[i] = idex + i < buff.length ? buff[idex + i] : (byte)0;
            ++i;
        }
    }

    private static int getByteLength(byte[] buff) {
        int n = 0;
        while (n < buff.length) {
            if (buff[n] == 0) break;
            ++n;
        }
        if (n == buff.length - 1 && buff[buff.length - 1] != 0) {
            return buff.length;
        }
        return n;
    }

    @Override
    public String getTcpCertPath() {
        return this.tcpCertPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerConnection other = (DockerConnection)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /* synthetic */ DockerConnection(String string, String string2, String string3, String string4, DockerConnection dockerConnection) {
        this(string, string2, string3, string4);
    }

    /* synthetic */ DockerConnection(String string, String string2, String string3, String string4, String string5, DockerConnection dockerConnection) {
        this(string, string2, string3, string4, string5);
    }

    public static class Builder {
        private String unixSocketPath;
        private String name;
        private String tcpHost;
        private String tcpCertPath;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder unixSocket(String unixSocketPath) {
            if (unixSocketPath != null && !unixSocketPath.matches("\\w+://.*")) {
                unixSocketPath = "unix://" + unixSocketPath;
            }
            this.unixSocketPath = unixSocketPath;
            return this;
        }

        public Builder tcpHost(String tcpHost) {
            if (tcpHost != null) {
                if (!tcpHost.matches("\\w+://.*")) {
                    tcpHost = "tcp://" + tcpHost;
                }
                this.tcpHost = tcpHost.replace("tcp://", "http://");
            }
            return this;
        }

        public Builder tcpCertPath(String tcpCertPath) {
            this.tcpCertPath = tcpCertPath;
            if (this.tcpHost != null && this.tcpCertPath != null) {
                this.tcpHost = this.tcpHost.replace("http://", "https://");
            }
            return this;
        }

        public DockerConnection build() {
            if (this.unixSocketPath != null) {
                return new DockerConnection(this.name, this.unixSocketPath, null, null, null);
            }
            return new DockerConnection(this.name, this.tcpHost, this.tcpCertPath, null, null, null);
        }
    }

    public static class Defaults {
        public static final String DEFAULT_UNIX_SOCKET_PATH = "unix:///var/run/docker.sock";
        private boolean settingsResolved;
        private String name;
        private final Map<EnumDockerConnectionSettings, Object> settings;

        public Defaults() {
            block15: {
                this.name = null;
                this.settings = new HashMap<EnumDockerConnectionSettings, Object>();
                try {
                    if (this.defaultsWithUnixSocket() || this.defaultsWithSystemEnv() || this.defaultWithShellEnv()) {
                        this.settingsResolved = true;
                        try {
                            Throwable throwable = null;
                            Object var2_5 = null;
                            try (DockerConnection connection = new Builder().unixSocket(this.getUnixSocketPath()).tcpHost(this.getTcpHost()).tcpCertPath(this.getTcpCertPath()).build();){
                                connection.open(false);
                                IDockerConnectionInfo info = connection.getInfo();
                                if (info != null) {
                                    this.name = info.getName();
                                }
                                break block15;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (DockerException e) {
                            this.settingsResolved = false;
                        }
                        break block15;
                    }
                    this.settingsResolved = false;
                    Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.core", Messages.Missing_Default_Settings));
                }
                catch (DockerException e) {
                    Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", Messages.Missing_Default_Settings, (Throwable)e));
                }
            }
        }

        private boolean defaultsWithUnixSocket() {
            File unixSocketFile = new File("/var/run/docker.sock");
            if (unixSocketFile.exists() && unixSocketFile.canRead()) {
                try {
                    UnixSocketAddress address = new UnixSocketAddress(unixSocketFile);
                    UnixSocketChannel channel = UnixSocketChannel.open((UnixSocketAddress)address);
                    channel.close();
                    this.settings.put(EnumDockerConnectionSettings.BINDING_MODE, (Object)EnumDockerConnectionSettings.UNIX_SOCKET);
                    this.settings.put(EnumDockerConnectionSettings.UNIX_SOCKET_PATH, DEFAULT_UNIX_SOCKET_PATH);
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean defaultsWithSystemEnv() {
            String dockerHostEnv = System.getenv("DOCKER_HOST");
            if (dockerHostEnv != null) {
                this.settings.put(EnumDockerConnectionSettings.BINDING_MODE, (Object)EnumDockerConnectionSettings.TCP_CONNECTION);
                this.settings.put(EnumDockerConnectionSettings.TCP_HOST, dockerHostEnv);
                String tlsVerifyEnv = System.getenv("DOCKER_TLS_VERIFY");
                if (tlsVerifyEnv != null && tlsVerifyEnv.equals("1")) {
                    this.settings.put(EnumDockerConnectionSettings.TCP_TLS_VERIFY, Boolean.TRUE);
                    String dockerCertPathEnv = System.getenv("DOCKER_CERT_PATH");
                    if (dockerCertPathEnv != null) {
                        this.settings.put(EnumDockerConnectionSettings.TCP_CERT_PATH, dockerCertPathEnv);
                    }
                } else {
                    this.settings.put(EnumDockerConnectionSettings.TCP_TLS_VERIFY, Boolean.FALSE);
                }
                return true;
            }
            return false;
        }

        private boolean defaultWithShellEnv() throws DockerException {
            int exitValue;
            Process process;
            block9: {
                String connectionSettingsDetectionScriptName;
                block8: {
                    connectionSettingsDetectionScriptName = this.getConnectionSettingsDetectionScriptName();
                    if (connectionSettingsDetectionScriptName != null) break block8;
                    Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.core", Messages.Docker_No_Settings_Description_Script));
                    return false;
                }
                File connectionSettingsDetectionScript = this.getConnectionSettingsDetectionScript(connectionSettingsDetectionScriptName);
                String[] cmdArray = this.getConnectionSettingsDetectionCommandArray(connectionSettingsDetectionScript);
                process = Runtime.getRuntime().exec(cmdArray);
                process.waitFor();
                exitValue = process.exitValue();
                if (exitValue != 0) break block9;
                InputStream processInputStream = process.getInputStream();
                Properties dockerSettings = new Properties();
                dockerSettings.load(processInputStream);
                this.settings.put(EnumDockerConnectionSettings.BINDING_MODE, (Object)EnumDockerConnectionSettings.TCP_CONNECTION);
                if (dockerSettings.containsKey("DOCKER_HOST")) {
                    this.settings.put(EnumDockerConnectionSettings.TCP_HOST, dockerSettings.get("DOCKER_HOST").toString());
                }
                if (dockerSettings.containsKey("DOCKER_CERT_PATH")) {
                    this.settings.put(EnumDockerConnectionSettings.TCP_CERT_PATH, dockerSettings.get("DOCKER_CERT_PATH").toString());
                }
                if (dockerSettings.containsKey("DOCKER_TLS_VERIFY")) {
                    this.settings.put(EnumDockerConnectionSettings.TCP_TLS_VERIFY, dockerSettings.get("DOCKER_TLS_VERIFY").toString().equals("1"));
                }
                return true;
            }
            try {
                if (exitValue != 1) {
                    InputStream processErrorStream = process.getErrorStream();
                    String errorMessage = this.streamToString(processErrorStream);
                    Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", errorMessage));
                }
            }
            catch (IOException | IllegalArgumentException | InterruptedException e) {
                throw new DockerException(Messages.Retrieve_Default_Settings_Failure, e);
            }
            return false;
        }

        private String[] getConnectionSettingsDetectionCommandArray(File script) {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().startsWith("win")) {
                return new String[]{"cmd.exe", "/C", script.getAbsolutePath()};
            }
            if (osName.toLowerCase().startsWith("mac") || osName.toLowerCase().contains("linux") || osName.toLowerCase().contains("nix")) {
                return new String[]{script.getAbsolutePath()};
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private File getConnectionSettingsDetectionScript(String scriptName) {
            File script = Activator.getDefault().getBundle().getDataFile(scriptName);
            if (script == null || script.exists() && script.lastModified() >= Activator.getDefault().getBundle().getLastModified()) return script;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    FileOutputStream output = new FileOutputStream(script);
                    try {
                        try (InputStream is = DockerConnection.class.getResourceAsStream("/resources/" + scriptName);){
                            int n;
                            byte[] buff = new byte[1024];
                            while ((n = is.read(buff)) > 0) {
                                output.write(buff, 0, n);
                            }
                            script.setExecutable(true);
                        }
                        if (output == null) return script;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (output == null) throw throwable;
                        output.close();
                        throw throwable;
                    }
                    output.close();
                    return script;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.logErrorMessage(e.getMessage());
            }
            return script;
        }

        private String getConnectionSettingsDetectionScriptName() {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().startsWith("win")) {
                return "script.bat";
            }
            if (osName.toLowerCase().startsWith("mac") || osName.toLowerCase().contains("linux") || osName.toLowerCase().contains("nix")) {
                return "script.sh";
            }
            return null;
        }

        private String streamToString(InputStream stream) {
            BufferedReader buff = new BufferedReader(new InputStreamReader(stream));
            StringBuffer res = new StringBuffer();
            String line = "";
            try {
                while ((line = buff.readLine()) != null) {
                    res.append(System.getProperty("line.separator"));
                    res.append(line);
                }
                buff.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return res.length() > 0 ? res.substring(1) : "";
        }

        public boolean isSettingsResolved() {
            return this.settingsResolved;
        }

        public String getName() {
            return this.name;
        }

        public EnumDockerConnectionSettings getBindingMode() {
            if (this.settings.containsKey((Object)EnumDockerConnectionSettings.BINDING_MODE)) {
                return (EnumDockerConnectionSettings)((Object)this.settings.get((Object)EnumDockerConnectionSettings.BINDING_MODE));
            }
            return EnumDockerConnectionSettings.UNIX_SOCKET;
        }

        public String getUnixSocketPath() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.UNIX_SOCKET_PATH);
        }

        public String getTcpHost() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.TCP_HOST);
        }

        public boolean getTcpTlsVerify() {
            if (this.settings.containsKey((Object)EnumDockerConnectionSettings.TCP_TLS_VERIFY)) {
                return (Boolean)this.settings.get((Object)EnumDockerConnectionSettings.TCP_TLS_VERIFY);
            }
            return false;
        }

        public String getTcpCertPath() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.TCP_CERT_PATH);
        }
    }

    private class LogThread
    extends AbstractKillableThread
    implements ILogger {
        private String id;
        private DockerClient copyClient;
        private OutputStream outputStream;
        private boolean follow;

        public LogThread(String id, DockerClient copyClient, boolean follow) {
            this.id = id;
            this.copyClient = copyClient;
            this.follow = follow;
        }

        @Override
        public LogThread clone() {
            return new LogThread(this.id, this.copyClient, this.follow);
        }

        @Override
        public void setOutputStream(OutputStream stream) {
            this.outputStream = stream;
        }

        @Override
        public void execute() throws InterruptedException, IOException {
            try {
                try {
                    IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
                    boolean timestamps = preferences.getBoolean("logTimestamp", true);
                    LogStream stream = null;
                    stream = timestamps ? this.copyClient.logs(this.id, new DockerClient.LogsParameter[]{DockerClient.LogsParameter.FOLLOW, DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR, DockerClient.LogsParameter.TIMESTAMPS}) : this.copyClient.logs(this.id, new DockerClient.LogsParameter[]{DockerClient.LogsParameter.FOLLOW, DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR});
                    int delayTime = 100;
                    do {
                        Thread.sleep(delayTime);
                        delayTime = 1000;
                        while (stream.hasNext()) {
                            ByteBuffer b = ((LogMessage)stream.next()).content();
                            byte[] bytes = new byte[b.remaining()];
                            b.get(bytes);
                            if (this.outputStream == null) continue;
                            this.outputStream.write(bytes);
                        }
                    } while (this.follow && !this.stop);
                    DockerConnection.this.listContainers();
                }
                catch (DockerRequestException e) {
                    Activator.logErrorMessage(e.message());
                    throw new InterruptedException();
                }
                catch (com.spotify.docker.client.DockerException | IOException e) {
                    Activator.logErrorMessage(e.getMessage());
                    throw new InterruptedException();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SocketTimeoutException) {
                        this.execute();
                    } else {
                        Activator.logErrorMessage(e.getMessage());
                    }
                    this.follow = false;
                    this.copyClient.close();
                    if (this.outputStream != null) {
                        this.outputStream.close();
                    }
                }
            }
            finally {
                this.follow = false;
                this.copyClient.close();
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
        }
    }
}

