/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.IdClassReference;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrimaryKeyValidator
implements JpaValidator {
    private final IdTypeMapping typeMapping;
    public static final String[] EMPTY_STRING_ARRAY = StringTools.EMPTY_STRING_ARRAY;
    protected static final String[] ID_MAPPING_KEYS_ARRAY = new String[]{"id", "embeddedId"};
    protected static final Iterable<String> ID_MAPPING_KEYS = IterableTools.iterable((Object[])ID_MAPPING_KEYS_ARRAY);
    protected static final String[] SINGLE_RELATIONSHIP_MAPPING_KEYS_ARRAY = new String[]{"manyToOne", "oneToOne"};
    protected static final Iterable<String> SINGLE_RELATIONSHIP_MAPPING_KEYS = IterableTools.iterable((Object[])SINGLE_RELATIONSHIP_MAPPING_KEYS_ARRAY);

    protected AbstractPrimaryKeyValidator(IdTypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    protected IdTypeMapping typeMapping() {
        return this.typeMapping;
    }

    protected IdClassReference idClassReference() {
        return this.typeMapping().getIdClassReference();
    }

    protected TextRange getAttributeMappingTextRange(AttributeMapping attributeMapping) {
        SpecifiedPersistentAttribute attribute = attributeMapping.getPersistentAttribute();
        if (attribute.isVirtual()) {
            return attribute.getValidationTextRange();
        }
        return attributeMapping.getValidationTextRange();
    }

    protected void validatePrimaryKeyIsNotRedefined(List<IMessage> messages, IReporter reporter) {
        if (this.definesPrimaryKeyOnAncestor(this.typeMapping())) {
            if (this.idClassReference().isSpecified()) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_PK_REDEFINED_ID_CLASS));
            }
            for (AttributeMapping each : this.getPrimaryKeyMappingsDefinedLocally(this.typeMapping())) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)each.getResource(), (TextRange)this.getAttributeMappingTextRange(each), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_PK_REDEFINED_ID_ATTRIBUTE));
            }
            return;
        }
    }

    protected void validateIdClassIsUsedIfNecessary(List<IMessage> messages, IReporter reporter) {
        if (!this.declaresIdClassInHierarchy() && this.idClassIsRequired()) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.typeMapping().getValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_REQUIRED));
        }
    }

    protected void validateOneOfIdClassOrEmbeddedIdIsUsed(List<IMessage> messages, IReporter reporter) {
        if (this.declaresIdClassLocally() && IterableTools.size(this.typeMapping().getAllAttributeMappings("embeddedId")) > 0) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.typeMapping().getValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_AND_EMBEDDED_ID_BOTH_USED));
        }
    }

    protected void validateOneOfEmbeddedOrIdIsUsed(List<IMessage> messages, IReporter reporter) {
        if (this.definesEmbeddedIdMapping(this.typeMapping) && this.definesIdMapping(this.typeMapping)) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.typeMapping().getValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_AND_EMBEDDED_ID_BOTH_USED));
        }
    }

    protected void validateOneEmbeddedId(List<IMessage> messages, IReporter reporter) {
        if (IterableTools.size(this.getEmbeddedIdMappings(this.typeMapping())) > 1) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.typeMapping().getValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_MULTIPLE_EMBEDDED_ID));
        }
    }

    protected void validateMapsIdMappings(List<IMessage> messages, IReporter reporter) {
        for (SingleRelationshipMapping2_0 mapsIdRelationshipMapping : this.getMapsIdMappingsDefinedLocally(this.typeMapping())) {
            AttributeMapping resolvedAttributeMapping;
            if (this.definesIdClass(this.typeMapping())) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)mapsIdRelationshipMapping.getResource(), (TextRange)this.getAttributeMappingTextRange(mapsIdRelationshipMapping), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_WITH_MAPS_ID, (Object[])new Object[]{mapsIdRelationshipMapping.getName()}));
            }
            if ((resolvedAttributeMapping = mapsIdRelationshipMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getDerivedIdAttributeMapping()) == null || ClassNameTools.isAutoboxEquivalent((String)resolvedAttributeMapping.getPersistentAttribute().getTypeName(), (String)this.getTargetEntityPrimaryKeyTypeName(mapsIdRelationshipMapping))) continue;
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)mapsIdRelationshipMapping.getResource(), (TextRange)this.getAttributeMappingTextRange(mapsIdRelationshipMapping), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_MAPS_ID_ATTRIBUTE_TYPE_DOES_NOT_AGREE, (Object[])new Object[]{mapsIdRelationshipMapping.getName()}));
        }
    }

    protected void validateIdClass(JavaPersistentType idClass, List<IMessage> messages, IReporter reporter) {
        if (idClass == null) {
            return;
        }
        if (this.hasDerivedIdMappingMatchingIdClass(idClass)) {
            this.validateIdClass_derivedIdMappingMatchingIdClass(idClass, messages, reporter);
            return;
        }
        for (JavaSpecifiedPersistentAttribute idClassAttribute : this.getAllIdClassAttributes(idClass)) {
            boolean foundMatch = false;
            for (AttributeMapping attributeMapping : this.getAttributeMappings(this.typeMapping())) {
                if (!idClassAttribute.getName().equals(attributeMapping.getName())) continue;
                foundMatch = true;
                if (!this.definesPrimaryKey(attributeMapping)) {
                    messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NOT_PRIMARY_KEY, (Object[])new Object[]{idClassAttribute.getName()}));
                }
                String idClassAttributeTypeName = idClassAttribute.getTypeName(idClass);
                String attributeMappingTypeName = this.getTypeNameForIdClass(attributeMapping);
                if (attributeMappingTypeName == null || ClassNameTools.isAutoboxEquivalent((String)idClassAttributeTypeName, (String)attributeMappingTypeName)) continue;
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_TYPE_DOES_NOT_AGREE, (Object[])new Object[]{idClassAttribute.getName(), idClassAttributeTypeName}));
            }
            if (foundMatch) continue;
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NO_MATCH, (Object[])new Object[]{idClassAttribute.getName()}));
        }
        for (AttributeMapping attributeMapping : this.getPrimaryKeyMappings(this.typeMapping())) {
            AccessType type = attributeMapping.getPersistentAttribute().getDeclaringPersistentType().getAccess();
            if (type == AccessType.FIELD) {
                this.checkMissingAttribute(idClass, attributeMapping, messages, reporter);
                continue;
            }
            if (type != AccessType.PROPERTY) continue;
            if (!IterableTools.contains(this.getIdClassFieldNames(idClass), (Object)attributeMapping.getName())) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_DOES_NOT_EXIST, (Object[])new Object[]{attributeMapping.getName()}));
                continue;
            }
            this.checkMissingAttributeWithPropertyAccess(idClass, attributeMapping, messages, reporter);
        }
        if (this.typeMapping().getPersistentType().getAccess() == AccessType.PROPERTY) {
            this.validateIdClassAttributesWithPropertyAccess(idClass, messages, reporter);
        }
        this.validateIdClassConstructor(idClass, messages, reporter);
    }

    protected TextRange getIdClassRefValidationTextRange() {
        return this.idClassReference().getValidationTextRange();
    }

    protected void checkMissingAttribute(JavaPersistentType idClass, AttributeMapping attributeMapping, List<IMessage> messages, IReporter reporter) {
        if (!IterableTools.contains(this.getIdClassAttributeNames(idClass), (Object)attributeMapping.getName())) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_DOES_NOT_EXIST, (Object[])new Object[]{attributeMapping.getName()}));
        }
    }

    protected abstract void validateIdClassAttributesWithPropertyAccess(JavaPersistentType var1, List<IMessage> var2, IReporter var3);

    protected void validateIdClassConstructor(JavaPersistentType idClass, List<IMessage> messages, IReporter reporter) {
        if (!idClass.getJavaResourceType().hasNoArgConstructor()) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_MISSING_NO_ARG_CONSTRUCTOR, (Object[])new Object[]{idClass.getName()}));
        }
    }

    protected void checkMissingAttributeWithPropertyAccess(JavaPersistentType idClass, AttributeMapping attributeMapping, List<IMessage> messages, IReporter reporter) {
    }

    protected void validateIdClass_derivedIdMappingMatchingIdClass(JavaPersistentType idClass, List<IMessage> messages, IReporter reporter) {
        HashBag errorMappings = new HashBag();
        for (AttributeMapping each : IterableTools.concatenate((Iterable[])new Iterable[]{this.getIdMappings(this.typeMapping()), this.getEmbeddedIdMappings(this.typeMapping())})) {
            errorMappings.add(each);
        }
        HashBag errorDerivedIdMappings = new HashBag();
        for (AttributeMapping each : this.getDerivedIdMappings(this.typeMapping())) {
            if (idClass.getName().equals(this.getTargetEntityPrimaryKeyTypeName((SingleRelationshipMapping2_0)each))) {
                errorDerivedIdMappings.add(each);
                continue;
            }
            errorMappings.add(each);
        }
        for (AttributeMapping each : errorMappings) {
            this.addNoIdClassAttributeMatchError(each, messages);
        }
        if (IterableTools.size((Iterable)errorDerivedIdMappings) > 1) {
            for (AttributeMapping each : errorDerivedIdMappings) {
                this.addDuplicateIdClassAttributeMatchError(each, messages);
            }
        }
    }

    protected void addNoIdClassAttributeMatchError(AttributeMapping attributeMapping, List<IMessage> messages) {
        messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_NO_MATCH, (Object[])new Object[]{attributeMapping.getName()}));
    }

    protected void addDuplicateIdClassAttributeMatchError(AttributeMapping attributeMapping, List<IMessage> messages) {
        messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_DUPLICATE_MATCH, (Object[])new Object[]{attributeMapping.getName()}));
    }

    protected void validateIdClassPropertyMethods(JavaPersistentType idClass, List<IMessage> messages, IReporter reporter) {
        for (JavaSpecifiedPersistentAttribute attribute : this.getAllIdClassAttributes(idClass)) {
            JavaResourceMethod setter;
            PropertyAccessor accessor = (PropertyAccessor)attribute.getAccessor();
            JavaResourceMethod getter = accessor.getResourceGetter();
            if (getter != null) {
                this.validatePropertyMethod(idClass, getter.getMethodName(), messages, reporter);
            }
            if ((setter = accessor.getResourceSetter()) == null) continue;
            this.validatePropertyMethod(idClass, setter.getMethodName(), messages, reporter);
        }
    }

    private void validatePropertyMethod(JavaPersistentType idClass, String methodName, List<IMessage> messages, IReporter reporter) {
        JavaResourceMethod method = idClass.getJavaResourceType().getMethod(methodName);
        if (!method.isPublicOrProtected()) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.typeMapping().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_PROPERTY_METHOD_NOT_PUBLIC, (Object[])new Object[]{idClass.getJavaResourceType().getTypeBinding().getQualifiedName(), methodName}));
        }
    }

    protected Iterable<String> getIdClassAttributeNames(JavaPersistentType idClass) {
        return IterableTools.transform(this.getAllIdClassAttributes(idClass), PersistentAttribute.NAME_TRANSFORMER);
    }

    protected Iterable<JavaSpecifiedPersistentAttribute> getAllIdClassAttributes(JavaPersistentType idClass) {
        return new SubIterableWrapper(idClass.getAllAttributes());
    }

    protected Iterable<String> getIdClassFieldNames(JavaPersistentType idClass) {
        return IterableTools.transform((Iterable)idClass.getJavaResourceType().getFields(), (Transformer)JavaResourceMember.NAME_TRANSFORMER);
    }

    protected boolean definesPrimaryKeyOnAncestor(IdTypeMapping typeMapping) {
        for (IdTypeMapping each : typeMapping.getInheritanceHierarchy()) {
            if (each == typeMapping || !this.definesPrimaryKey(each)) continue;
            return true;
        }
        return false;
    }

    protected boolean definesPrimaryKey(IdTypeMapping typeMapping) {
        return this.getIdClass(typeMapping) != null || !IterableTools.isEmpty(this.getPrimaryKeyMappings(typeMapping));
    }

    protected boolean definesComplexPrimaryKey(IdTypeMapping typeMapping) {
        return this.definesIdClass(typeMapping) || this.getEmbeddedIdMapping(typeMapping) != null;
    }

    protected String getPrimaryKeyTypeName(IdTypeMapping typeMapping) {
        JavaPersistentType idClass = this.getIdClass(typeMapping);
        if (idClass != null) {
            return idClass.getName();
        }
        EmbeddedIdMapping embeddedId = this.getEmbeddedIdMapping(typeMapping);
        if (embeddedId != null) {
            return embeddedId.getPersistentAttribute().getTypeName(typeMapping.getPersistentType());
        }
        IdMapping id = this.getIdMapping(typeMapping);
        if (id != null) {
            return id.getPersistentAttribute().getTypeName(typeMapping.getPersistentType());
        }
        return null;
    }

    protected boolean definesPrimaryKey(AttributeMapping attributeMapping) {
        String mappingKey = attributeMapping.getKey();
        if (IterableTools.contains(this.getIdMappingKeys(), (Object)mappingKey)) {
            return true;
        }
        if (IterableTools.contains(this.getSingleRelationshipMappingKeys(), (Object)mappingKey)) {
            SingleRelationshipMapping2_0 relationshipMapping = (SingleRelationshipMapping2_0)attributeMapping;
            return relationshipMapping.getDerivedIdentity().usesIdDerivedIdentityStrategy() || relationshipMapping.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
        }
        return false;
    }

    protected Iterable<String> getIdMappingKeys() {
        return ID_MAPPING_KEYS;
    }

    protected Iterable<String> getSingleRelationshipMappingKeys() {
        return SINGLE_RELATIONSHIP_MAPPING_KEYS;
    }

    protected boolean declaresIdClassLocally() {
        return this.typeMapping().getIdClassReference().isSpecified();
    }

    protected boolean declaresIdClassInHierarchy() {
        return this.idClassReference().isSpecified();
    }

    protected boolean definesIdClass(IdTypeMapping typeMapping) {
        return this.getIdClass(typeMapping) != null;
    }

    protected boolean definesIdClassOnAncestor(IdTypeMapping typeMapping) {
        for (IdTypeMapping each : typeMapping.getInheritanceHierarchy()) {
            if (each == typeMapping || !this.definesIdClass(each)) continue;
            return true;
        }
        return false;
    }

    protected JavaPersistentType getIdClass(IdTypeMapping typeMapping) {
        for (IdTypeMapping each : typeMapping.getInheritanceHierarchy()) {
            if (each.getIdClassReference().getIdClass() == null) continue;
            return each.getIdClassReference().getIdClass();
        }
        return null;
    }

    protected Iterable<AttributeMapping> getAttributeMappings(TypeMapping typeMapping) {
        return IterableTools.filter(typeMapping.getAllAttributeMappings(), AttributeMapping.IS_NOT_TRANSIENT);
    }

    protected Iterable<AttributeMapping> getPrimaryKeyMappings(TypeMapping typeMapping) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getIdMappings(typeMapping), this.getEmbeddedIdMappings(typeMapping), this.getDerivedIdMappings(typeMapping), this.getMapsIdMappings(typeMapping)});
    }

    protected Iterable<AttributeMapping> getPrimaryKeyMappingsDefinedLocally(TypeMapping typeMapping) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getIdMappingsDefinedLocally(typeMapping), this.getEmbeddedIdMappingsDefinedLocally(typeMapping), this.getDerivedIdMappingsDefinedLocally(typeMapping), this.getMapsIdMappingsDefinedLocally(typeMapping)});
    }

    protected boolean hasAnyPrimaryKeyMappings(TypeMapping typeMapping) {
        return !IterableTools.isEmpty(this.getPrimaryKeyMappings(typeMapping));
    }

    protected IdMapping getIdMapping(TypeMapping typeMapping) {
        Iterable<IdMapping> idMappings = this.getIdMappings(typeMapping);
        if (IterableTools.size(idMappings) == 1) {
            return idMappings.iterator().next();
        }
        return null;
    }

    protected Iterable<IdMapping> getIdMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAllAttributeMappings("id"));
    }

    protected Iterable<IdMapping> getIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAttributeMappings("id"));
    }

    protected boolean definesEmbeddedIdMapping(TypeMapping typeMapping) {
        return !IterableTools.isEmpty(this.getEmbeddedIdMappings(typeMapping));
    }

    protected boolean definesIdMapping(TypeMapping typeMapping) {
        return !IterableTools.isEmpty(this.getIdMappings(typeMapping));
    }

    protected EmbeddedIdMapping getEmbeddedIdMapping(TypeMapping typeMapping) {
        Iterable<EmbeddedIdMapping> embeddedIdMappings = this.getEmbeddedIdMappings(typeMapping);
        if (IterableTools.size(embeddedIdMappings) == 1) {
            return embeddedIdMappings.iterator().next();
        }
        return null;
    }

    protected Iterable<EmbeddedIdMapping> getEmbeddedIdMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAllAttributeMappings("embeddedId"));
    }

    protected Iterable<EmbeddedIdMapping> getEmbeddedIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAttributeMappings("embeddedId"));
    }

    protected Iterable<SingleRelationshipMapping2_0> getDerivedIdMappings(TypeMapping typeMapping) {
        return IterableTools.filter(this.getAllSingleRelationshipMappings(typeMapping), SingleRelationshipMapping2_0.TYPE_MAPPING_USES_ID_DERIVED_IDENTITY_STRATEGY);
    }

    protected Iterable<SingleRelationshipMapping2_0> getAllSingleRelationshipMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(this.getAllSingleRelationshipMappings_(typeMapping));
    }

    protected Iterable<AttributeMapping> getAllSingleRelationshipMappings_(TypeMapping typeMapping) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{typeMapping.getAllAttributeMappings("oneToOne"), typeMapping.getAllAttributeMappings("manyToOne")});
    }

    protected Iterable<SingleRelationshipMapping2_0> getDerivedIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return IterableTools.filter(this.getSingleRelationshipMappings(typeMapping), SingleRelationshipMapping2_0.TYPE_MAPPING_USES_ID_DERIVED_IDENTITY_STRATEGY);
    }

    protected Iterable<SingleRelationshipMapping2_0> getSingleRelationshipMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(this.getSingleRelationshipMappings_(typeMapping));
    }

    protected Iterable<AttributeMapping> getSingleRelationshipMappings_(TypeMapping typeMapping) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{typeMapping.getAttributeMappings("oneToOne"), typeMapping.getAttributeMappings("manyToOne")});
    }

    protected Iterable<SingleRelationshipMapping2_0> getMapsIdMappings(TypeMapping typeMapping) {
        return IterableTools.filter(this.getAllSingleRelationshipMappings(typeMapping), SingleRelationshipMapping2_0.TYPE_MAPPING_USES_MAPS_ID_DERIVED_IDENTITY_STRATEGY);
    }

    protected Iterable<SingleRelationshipMapping2_0> getMapsIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return IterableTools.filter(this.getSingleRelationshipMappings(typeMapping), SingleRelationshipMapping2_0.TYPE_MAPPING_USES_MAPS_ID_DERIVED_IDENTITY_STRATEGY);
    }

    protected boolean idClassIsRequired() {
        int simplePrimaryKeyMappingCount = IterableTools.size(this.getIdMappings(this.typeMapping()));
        if (simplePrimaryKeyMappingCount > 1) {
            return true;
        }
        for (SingleRelationshipMapping2_0 relationshipMapping : this.getDerivedIdMappings(this.typeMapping())) {
            Entity entity = relationshipMapping.getResolvedTargetEntity();
            if (entity == null) continue;
            if (this.definesComplexPrimaryKey(entity)) {
                return true;
            }
            if (++simplePrimaryKeyMappingCount <= 1) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDerivedIdMappingMatchingIdClass(JavaPersistentType idClass) {
        for (SingleRelationshipMapping2_0 each : this.getDerivedIdMappings(this.typeMapping())) {
            String primaryKeyTypeName = this.getTargetEntityPrimaryKeyTypeName(each);
            if (!idClass.getName().equals(primaryKeyTypeName)) continue;
            return true;
        }
        return false;
    }

    protected String getTargetEntityPrimaryKeyTypeName(SingleRelationshipMapping2_0 relationshipMapping) {
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity != null) {
            return this.getPrimaryKeyTypeName(targetEntity);
        }
        return null;
    }

    protected String getTypeNameForIdClass(AttributeMapping attributeMapping) {
        SingleRelationshipMapping2_0 relationshipMapping;
        Entity targetEntity;
        String mappingKey = attributeMapping.getKey();
        if (IterableTools.contains(this.getIdMappingKeys(), (Object)mappingKey)) {
            return attributeMapping.getPersistentAttribute().getTypeName(this.typeMapping().getPersistentType());
        }
        if (IterableTools.contains(this.getSingleRelationshipMappingKeys(), (Object)mappingKey) && (targetEntity = (relationshipMapping = (SingleRelationshipMapping2_0)attributeMapping).getResolvedTargetEntity()) != null) {
            return this.getPrimaryKeyTypeName(targetEntity);
        }
        return null;
    }
}

