/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaBaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.EmbeddedIdMapping2_0;
import org.eclipse.jpt.jpa.core.resource.java.EmbeddedIdAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEmbeddedIdMapping
extends AbstractJavaBaseEmbeddedMapping<EmbeddedIdAnnotation>
implements EmbeddedIdMapping2_0,
JavaEmbeddedIdMapping {
    protected boolean derived;

    protected AbstractJavaEmbeddedIdMapping(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void update() {
        super.update();
        this.setDerived(this.buildDerived());
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    protected void setDerived(boolean derived) {
        boolean old = this.derived;
        this.derived = derived;
        this.firePropertyChanged("derived", old, derived);
    }

    protected boolean buildDerived() {
        return this.isJpa2_0Compatible() && this.buildDerived_();
    }

    protected boolean buildDerived_() {
        return this.getTypeMapping().attributeIsDerivedId(this.getName());
    }

    @Override
    public String getKey() {
        return "embeddedId";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.EmbeddedId";
    }

    @Override
    protected Iterable<String> getEmbeddableOverridableAttributeMappingNames() {
        return this.derived ? EmptyIterable.instance() : super.getEmbeddableOverridableAttributeMappingNames();
    }

    @Override
    protected JavaAttributeOverrideContainer.ParentAdapter buildAttributeOverrideContainerParentAdapter() {
        return new AttributeOverrideContainerParentAdapter();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.derived && this.attributeOverrideContainer.getSpecifiedOverridesSize() > 0) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage((JpaModel)this.attributeOverrideContainer, this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED, this.getName()));
            } else {
                messages.add(this.buildValidationMessage((JpaModel)this.attributeOverrideContainer, this.attributeOverrideContainer.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED));
            }
        }
        this.validateTargetEmbeddableImplementsSerializable(messages, reporter);
        this.validateNoRelationshipMappingsOnTargetEmbeddable(messages, reporter);
        this.validateTargetEmbeddableImplementsEqualsAndHashcode(messages, reporter);
        this.validateTargetEmbeddableIsPublic(messages, reporter);
        this.validateTargetEmbeddableImplementsZeroArgConstructor(messages, reporter);
    }

    protected void validateTargetEmbeddableImplementsZeroArgConstructor(List<IMessage> messages, IReporter reporter) {
        String targetEmbeddableClassName;
        if (this.getTargetEmbeddable() != null && !TypeTools.hasPublicZeroArgConstructor((String)(targetEmbeddableClassName = this.getTargetEmbeddable().getPersistentType().getName()), (IJavaProject)this.getJavaProject())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR));
            }
        }
    }

    protected void validateTargetEmbeddableImplementsEqualsAndHashcode(List<IMessage> messages, IReporter reporter) {
        JavaResourceType resourceType;
        if (!(this.getTargetEmbeddable() == null || (resourceType = this.getTargetEmbeddable().getJavaResourceType()) == null || resourceType.hasHashCodeMethod() && resourceType.hasEqualsMethod())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE));
            }
        }
    }

    protected void validateTargetEmbeddableIsPublic(List<IMessage> messages, IReporter reporter) {
        if (this.getTargetEmbeddable() != null && !this.getTargetEmbeddable().getJavaResourceType().isPublic()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC));
            }
        }
    }

    protected void validateTargetEmbeddableImplementsSerializable(List<IMessage> messages, IReporter reporter) {
        String targetEmbeddableClassName;
        if (this.getTargetEmbeddable() != null && !TypeTools.isSerializable((String)(targetEmbeddableClassName = this.getTargetEmbeddable().getPersistentType().getName()), (IJavaProject)this.getJavaProject())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE));
            }
        }
    }

    protected void validateNoRelationshipMappingsOnTargetEmbeddable(List<IMessage> messages, IReporter reporter) {
        TypeMapping targetEmbeddableTypeMapping;
        if (this.getTargetEmbeddable() != null && ((targetEmbeddableTypeMapping = this.getTargetEmbeddable().getPersistentType().getMapping()).getAllAttributeMappings("manyToMany").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("manyToOne").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("oneToMany").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("oneToOne").iterator().hasNext())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeOverrideContainerParentAdapter
    extends AbstractJavaBaseEmbeddedMapping.AttributeOverrideContainerParentAdapter {
        public AttributeOverrideContainerParentAdapter() {
            super(AbstractJavaEmbeddedIdMapping.this);
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            return AbstractJavaEmbeddedIdMapping.this.isDerived() ? EmptyIterable.instance() : super.getAllOverridableNames();
        }

        @Override
        protected Iterable<String> getAllOverridableAttributeNames_(TypeMapping overriddenTypeMapping) {
            return IterableTools.filter(super.getAllOverridableAttributeNames_(overriddenTypeMapping), (Predicate)new OverrideContainer.ParentAdapter.AttributeIsOverridable(this));
        }
    }
}

