/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.DatabaseGenerator;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaDatabaseGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaGenerator;
import org.eclipse.jpt.jpa.core.resource.java.DatabaseGeneratorAnnotation;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaDatabaseGenerator<A extends DatabaseGeneratorAnnotation>
extends AbstractJavaGenerator<JavaGeneratorContainer, A>
implements JavaDatabaseGenerator {
    protected Integer specifiedInitialValue;
    protected int defaultInitialValue;
    protected Integer specifiedAllocationSize;
    protected int defaultAllocationSize;

    protected AbstractJavaDatabaseGenerator(JavaGeneratorContainer parent, A generatorAnnotation) {
        super(parent, generatorAnnotation);
        this.specifiedInitialValue = generatorAnnotation.getInitialValue();
        this.specifiedAllocationSize = generatorAnnotation.getAllocationSize();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedInitialValue_(((DatabaseGeneratorAnnotation)this.generatorAnnotation).getInitialValue());
        this.setSpecifiedAllocationSize_(((DatabaseGeneratorAnnotation)this.generatorAnnotation).getAllocationSize());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultInitialValue(this.buildDefaultInitialValue());
        this.setDefaultAllocationSize(this.buildDefaultAllocationSize());
    }

    @Override
    public int getInitialValue() {
        return this.specifiedInitialValue != null ? this.specifiedInitialValue : this.defaultInitialValue;
    }

    @Override
    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(Integer value) {
        ((DatabaseGeneratorAnnotation)this.generatorAnnotation).setInitialValue(value);
        this.setSpecifiedInitialValue_(value);
    }

    protected void setSpecifiedInitialValue_(Integer value) {
        Integer old = this.specifiedInitialValue;
        this.specifiedInitialValue = value;
        this.firePropertyChanged("specifiedInitialValue", old, value);
    }

    @Override
    public int getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    protected void setDefaultInitialValue(int value) {
        int old = this.defaultInitialValue;
        this.defaultInitialValue = value;
        this.firePropertyChanged("defaultInitialValue", old, value);
    }

    protected abstract int buildDefaultInitialValue();

    @Override
    public int getAllocationSize() {
        return this.specifiedAllocationSize != null ? this.specifiedAllocationSize : this.defaultAllocationSize;
    }

    @Override
    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(Integer size) {
        ((DatabaseGeneratorAnnotation)this.generatorAnnotation).setAllocationSize(size);
        this.setSpecifiedAllocationSize_(size);
    }

    protected void setSpecifiedAllocationSize_(Integer size) {
        Integer old = this.specifiedAllocationSize;
        this.specifiedAllocationSize = size;
        this.firePropertyChanged("specifiedAllocationSize", old, size);
    }

    @Override
    public int getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    protected void setDefaultAllocationSize(int size) {
        int old = this.defaultAllocationSize;
        this.defaultAllocationSize = size;
        this.firePropertyChanged("defaultAllocationSize", old, size);
    }

    protected int buildDefaultAllocationSize() {
        return 50;
    }

    @Override
    protected boolean isEquivalentTo_(Generator other) {
        return super.isEquivalentTo_(other) && this.isEquivalentTo_((DatabaseGenerator)other);
    }

    protected boolean isEquivalentTo_(DatabaseGenerator other) {
        return ObjectTools.equals((Object)this.specifiedAllocationSize, (Object)other.getSpecifiedAllocationSize()) && ObjectTools.equals((Object)this.specifiedInitialValue, (Object)other.getSpecifiedInitialValue());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    protected abstract String getSchema();

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    protected abstract String getCatalog();
}

