/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.AspectChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.jpa.core.jpa2_1.JpaFactory2_1;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaModel<P extends JpaModel>
extends AbstractModel
implements JpaModel {
    protected final P parent;
    private static final HashMap<Class<? extends AbstractJpaModel<?>>, HashSet<String>> NON_UPDATE_ASPECT_NAME_SETS = new HashMap();

    protected AbstractJpaModel(P parent) {
        this.checkParent((JpaModel)parent);
        this.parent = parent;
    }

    protected void checkParent(JpaModel p) {
        if (p == null) {
            if (this.requiresParent()) {
                throw new IllegalArgumentException("'parent' cannot be null");
            }
        } else if (this.forbidsParent()) {
            throw new IllegalArgumentException("'parent' must be null");
        }
    }

    protected boolean requiresParent() {
        return true;
    }

    protected final boolean forbidsParent() {
        return !this.requiresParent();
    }

    protected ChangeSupport buildChangeSupport() {
        return new AspectChangeSupport((Model)this, this.buildChangeSupportListener());
    }

    protected AspectChangeSupport.Listener buildChangeSupportListener() {
        return new AspectChangeSupportListener();
    }

    public Object getAdapter(Class adapter) {
        return PlatformTools.getAdapter((Object)this, (Class)adapter);
    }

    public P getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public JpaProject getJpaProject() {
        return this.parent.getJpaProject();
    }

    @Override
    public JpaProject.Manager getJpaProjectManager() {
        return this.getJpaProject().getManager();
    }

    @Override
    public JpaPlatform getJpaPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    protected IJavaProject getJavaProject() {
        return this.getJpaProject().getJavaProject();
    }

    protected JpaPlatform.Version getJpaPlatformVersion() {
        return this.getJpaPlatform().getJpaVersion();
    }

    protected boolean isJpa2_0Compatible() {
        return this.getJpaPlatformVersion().isCompatibleWithJpaVersion("2.0");
    }

    protected boolean isJpa2_1Compatible() {
        return this.getJpaPlatformVersion().isCompatibleWithJpaVersion("2.1");
    }

    protected JpaFactory2_0 getJpaFactory2_0() {
        return (JpaFactory2_0)this.getJpaFactory();
    }

    protected JpaFactory2_1 getJpaFactory2_1() {
        return (JpaFactory2_1)this.getJpaFactory();
    }

    protected JpaFactory getJpaFactory() {
        return this.getJpaPlatform().getJpaFactory();
    }

    protected JpaPlatformVariation getJpaPlatformVariation() {
        return this.getJpaPlatform().getJpaVariation();
    }

    protected JpaFile getJpaFile(IFile file) {
        return this.getJpaProject().getJpaFile(file);
    }

    protected JpaDataSource getDataSource() {
        return this.getJpaProject().getDataSource();
    }

    protected Database getDatabase() {
        return this.getDataSource().getDatabase();
    }

    protected boolean connectionProfileIsActive() {
        return this.getDataSource().connectionProfileIsActive();
    }

    protected Catalog resolveDbCatalog(String catalog) {
        Database database = this.getDatabase();
        return database == null ? null : database.getCatalogForIdentifier(catalog);
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectTriggersUpdate(aspectName)) {
            this.stateChanged();
        }
    }

    protected boolean aspectTriggersUpdate(String aspectName) {
        return !this.aspectDoesNotTriggerUpdate(aspectName);
    }

    protected boolean aspectDoesNotTriggerUpdate(String aspectName) {
        return aspectName == null || this.nonUpdateAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonUpdateAspectNames() {
        Class<?> thisClass = this.getClass();
        HashMap<Class<? extends AbstractJpaModel<?>>, HashSet<String>> hashMap = NON_UPDATE_ASPECT_NAME_SETS;
        synchronized (hashMap) {
            HashSet<String> nonUpdateAspectNames = NON_UPDATE_ASPECT_NAME_SETS.get(thisClass);
            if (nonUpdateAspectNames == null) {
                nonUpdateAspectNames = new HashSet();
                this.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
                NON_UPDATE_ASPECT_NAME_SETS.put(thisClass, nonUpdateAspectNames);
            }
            return nonUpdateAspectNames;
        }
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
    }

    @Override
    public void stateChanged() {
        this.fireStateChanged();
        if (this.parent != null) {
            this.parent.stateChanged();
        }
    }

    public class AspectChangeSupportListener
    implements AspectChangeSupport.Listener {
        public void aspectChanged(String aspectName) {
            AbstractJpaModel.this.aspectChanged(aspectName);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

