/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.debugger.core.IControlConnectionExtension;
import org.eclipse.datatools.sqltools.internal.core.AbstractControlConnection;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public abstract class AbstractControlConnectionExtension
implements IControlConnectionExtension {
    Set _skipSet = new HashSet();
    boolean _enabled = false;
    AbstractControlConnection _controlConnection;

    public AbstractControlConnectionExtension(AbstractControlConnection controlcon) {
        this._controlConnection = controlcon;
    }

    public IControlConnection getControlConnection() {
        return this._controlConnection;
    }

    public boolean getAutoAttachEnabled() {
        return this._enabled;
    }

    public void setAutoAttachEnabled(boolean b) {
        if (this._enabled == b) {
            return;
        }
        this._enabled = b;
        this._controlConnection.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSkip(Object id) {
        Set set = this._skipSet;
        synchronized (set) {
            this._skipSet.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSkip(Object id) {
        Set set = this._skipSet;
        synchronized (set) {
            this._skipSet.remove(id);
        }
    }

    protected Set getSkipSet() {
        return this._skipSet;
    }

    protected void attachConnection(String connId) throws CoreException {
        ILaunchConfigurationWorkingCopy config = LaunchHelper.createExternalClientConfiguration((DatabaseIdentifier)this._controlConnection.getDatabaseIdentifier(), (String)connId);
        config.launch("debug", (IProgressMonitor)new NullProgressMonitor());
    }
}

