/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.data;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MarkerStat
implements Comparable {
    private String mIdentifiant;
    private Collection mMarkers;
    private int mMaxSeverity;

    public MarkerStat(String identifiant) {
        this.mIdentifiant = identifiant;
        this.mMarkers = new ArrayList();
    }

    public void addMarker(IMarker marker) {
        this.mMarkers.add(marker);
        int severity = MarkerUtilities.getSeverity((IMarker)marker);
        if (severity > this.mMaxSeverity) {
            this.mMaxSeverity = severity;
        }
    }

    public int compareTo(Object o) {
        if (o instanceof MarkerStat) {
            MarkerStat stat = (MarkerStat)o;
            return this.mIdentifiant.compareTo(stat.getIdentifiant());
        }
        return 0;
    }

    public Collection getMarkers() {
        return this.mMarkers;
    }

    public int getCount() {
        return this.mMarkers.size();
    }

    public int getMaxSeverity() {
        return this.mMaxSeverity;
    }

    public String getIdentifiant() {
        return this.mIdentifiant;
    }
}

