/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyAnnotation;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;

public class SpringPropertiesReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private ISourceViewer fViewer;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private ProblemCollector fProblemCollector;
    private IReconcileEngine fEngine;

    public SpringPropertiesReconcileStrategy(ISourceViewer viewer, IReconcileEngine engine) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
        this.fEngine = engine;
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        try {
            IRegion startLineInfo = this.fDocument.getLineInformationOfOffset(subRegion.getOffset());
            IRegion endLineInfo = this.fDocument.getLineInformationOfOffset(subRegion.getOffset() + Math.max(0, subRegion.getLength() - 1));
            subRegion = startLineInfo.getOffset() == endLineInfo.getOffset() ? startLineInfo : new Region(startLineInfo.getOffset(), endLineInfo.getOffset() + Math.max(0, endLineInfo.getLength() - 1) - startLineInfo.getOffset());
        }
        catch (BadLocationException badLocationException) {
            subRegion = new Region(0, this.fDocument.getLength());
        }
        this.reconcile((IRegion)subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.getAnnotationModel() == null || this.fProblemCollector == null) {
            return;
        }
        this.fEngine.reconcile(this.fDocument, this.fProblemCollector, this.fProgressMonitor);
    }

    protected IContentType getContentType() {
        return TEXT_CONTENT_TYPE;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.fProblemCollector = this.createSpellingProblemCollector();
    }

    protected ProblemCollector createSpellingProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new ProblemCollector(model);
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    protected IAnnotationModel getAnnotationModel() {
        return this.fViewer.getAnnotationModel();
    }

    private static class ProblemCollector
    implements SpringPropertiesReconcileEngine.IProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map fAddAnnotations;
        private Object fLockObject;

        public ProblemCollector(IAnnotationModel annotationModel) {
            Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
            this.fAnnotationModel = annotationModel;
            this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
        }

        @Override
        public void accept(SpringPropertyProblem problem) {
            this.fAddAnnotations.put(new SpringPropertyAnnotation(problem), new Position(problem.getOffset(), problem.getLength()));
        }

        @Override
        public void beginCollecting() {
            this.fAddAnnotations = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endCollecting() {
            ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
            Object object = this.fLockObject;
            synchronized (object) {
                Iterator iter = this.fAnnotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!SpringPropertyAnnotation.TYPES.contains(annotation.getType())) continue;
                    toRemove.add(annotation);
                }
                Annotation[] annotationsToRemove = toRemove.toArray(new Annotation[toRemove.size()]);
                if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(annotationsToRemove, this.fAddAnnotations);
                } else {
                    int i = 0;
                    while (i < annotationsToRemove.length) {
                        this.fAnnotationModel.removeAnnotation(annotationsToRemove[i]);
                        ++i;
                    }
                    for (Annotation annotation : this.fAddAnnotations.keySet()) {
                        this.fAnnotationModel.addAnnotation(annotation, (Position)this.fAddAnnotations.get(annotation));
                    }
                }
            }
            this.fAddAnnotations = null;
        }
    }
}

