/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.jdt;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.refactoring.participants.ChangeMethodSignatureParticipant;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.refactoring.util.BeansRefactoringChangeUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.util.StringUtils;

public class BeansChangeMethodSignatureParticipant
extends ChangeMethodSignatureParticipant {
    private IMethod refactoredMethod;
    private String newName;

    protected boolean initialize(Object element) {
        IMethod method;
        IJavaProject javaProject;
        IProject project;
        if (element instanceof IMethod && SpringCoreUtils.isSpringProject((IResource)(project = (javaProject = (IJavaProject)(method = (IMethod)element).getAncestor(2)).getProject()))) {
            this.refactoredMethod = method;
            this.newName = this.getArguments().getNewName();
            if (this.newName.startsWith("set")) {
                this.newName = StringUtils.uncapitalize((String)this.newName.substring(3));
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return "Rename properties referenced in Spring Bean definitions";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashSet<IResource> processedResources = new HashSet<IResource>();
        CompositeChange result = new CompositeChange(this.getName());
        Set projects = BeansCorePlugin.getModel().getProjects();
        for (IBeansProject beansProject : projects) {
            Set beansConfigs = beansProject.getConfigs();
            for (IBeansConfig beansConfig : beansConfigs) {
                if (!processedResources.contains(beansConfig.getElementResource())) {
                    this.addChange(result, beansConfig.getElementResource(), pm);
                    processedResources.add(beansConfig.getElementResource());
                }
                for (IBeansImport import_ : beansConfig.getImports()) {
                    for (IBeansConfig config : import_.getImportedBeansConfigs()) {
                        if (processedResources.contains(config.getElementResource())) continue;
                        this.addChange(result, config.getElementResource(), pm);
                        processedResources.add(config.getElementResource());
                    }
                }
            }
        }
        return result.getChildren().length == 0 ? null : result;
    }

    protected void addChange(CompositeChange result, IResource resource, IProgressMonitor pm) throws CoreException {
        Change change;
        if (resource.exists() && (change = BeansRefactoringChangeUtils.createMethodRenameChange((IFile)resource, new IJavaElement[]{this.refactoredMethod}, new String[]{this.newName}, pm)) != null) {
            result.add(change);
        }
    }
}

