/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLruCache<K, V> {
    private static final float LOAD_FACTOR = 0.75f;
    private final int cacheSize;
    protected final LinkedHashMap<K, V> map;

    public SimpleLruCache(int cacheSize) {
        this.cacheSize = cacheSize;
        int capacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap<K, V>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > SimpleLruCache.this.cacheSize;
            }
        };
    }

    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized V put(K key, V value) {
        return this.map.put(key, value);
    }

    public synchronized int getUsedEntriesCount() {
        return this.map.size();
    }

    public LinkedHashMap<K, V> getMap() {
        return this.map;
    }
}

