/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg.xstream;

import com.atlassian.theplugin.commons.cfg.BambooServerCfg;
import com.atlassian.theplugin.commons.cfg.CrucibleServerCfg;
import com.atlassian.theplugin.commons.cfg.FishEyeServerCfg;
import com.atlassian.theplugin.commons.cfg.JiraServerCfg;
import com.atlassian.theplugin.commons.cfg.PrivateBambooServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.PrivateProjectConfiguration;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.ProjectConfiguration;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.cfg.SharedServerList;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import com.atlassian.theplugin.commons.cfg.xstream.EncodedStringConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.JDomDriver;
import java.util.ArrayList;
import java.util.Collection;

public final class JDomXStreamUtil {
    private static final String PLAN = "plan";
    private static final String PLAN_KEY = "key";
    private static final String GROUPED_KEY = "grouped";

    private JDomXStreamUtil() {
    }

    public static XStream getProjectJDomXStream() {
        return JDomXStreamUtil.getProjectJDomXStream(false);
    }

    public static XStream getProjectJDomXStream(boolean saveAll) {
        XStream xStream = new XStream((ReflectionProvider)new Sun14ReflectionProvider(), (HierarchicalStreamDriver)new JDomDriver());
        xStream.setMode(1002);
        xStream.alias("bamboo", BambooServerCfg.class);
        xStream.alias("crucible", CrucibleServerCfg.class);
        xStream.alias("jira", JiraServerCfg.class);
        xStream.alias("fisheye", FishEyeServerCfg.class);
        xStream.alias(PLAN, SubscribedPlan.class);
        xStream.omitField(ServerCfg.class, "deleted");
        if (!saveAll) {
            xStream.omitField(ServerCfg.class, "username");
            xStream.omitField(ServerCfg.class, "password");
            xStream.omitField(ServerCfg.class, "isPasswordStored");
            xStream.omitField(ServerCfg.class, "useDefaultCredentials");
            xStream.omitField(JiraServerCfg.class, "dontUseBasicAuth");
            xStream.omitField(JiraServerCfg.class, "basicHttpUser");
            xStream.omitField(BambooServerCfg.class, "timezoneOffset");
            xStream.omitField(CrucibleServerCfg.class, "fishEyeView");
        }
        xStream.aliasField("server-id", ServerCfg.class, "serverId");
        if (!saveAll) {
            xStream.omitField(ServerCfg.class, "isEnabled");
        }
        xStream.aliasField("use-favourites", ServerCfg.class, "isUseFavourites");
        xStream.aliasField("bamboo2", ServerCfg.class, "isBamboo2");
        xStream.aliasField("show-branches", ServerCfg.class, "showBranches");
        xStream.aliasField("my-branches-only", ServerCfg.class, "myBranchesOnly");
        xStream.alias("project-configuration", ProjectConfiguration.class);
        xStream.aliasField("default-crucible-server", ProjectConfiguration.class, "defaultCrucibleServerId");
        xStream.aliasField("default-crucible-project", ProjectConfiguration.class, "defaultCrucibleProject");
        xStream.aliasField("default-crucible-repo", ProjectConfiguration.class, "defaultCrucibleRepo");
        xStream.aliasField("default-fisheye-server", ProjectConfiguration.class, "defaultFishEyeServerId");
        xStream.aliasField("default-fisheye-repo", ProjectConfiguration.class, "defaultFishEyeRepo");
        xStream.aliasField("fisheye-project-path", ProjectConfiguration.class, "fishEyeProjectPath");
        xStream.aliasField("default-jira-server", ProjectConfiguration.class, "defaultJiraServerId");
        xStream.alias("private-server-cfg", PrivateServerCfgInfo.class);
        xStream.alias("private-bamboo-server-cfg", PrivateBambooServerCfgInfo.class);
        xStream.aliasField("server-id", PrivateServerCfgInfo.class, "serverId");
        xStream.aliasField("enabled", PrivateServerCfgInfo.class, "isEnabled");
        xStream.aliasField("timezone-offset", PrivateBambooServerCfgInfo.class, "timezoneOffset");
        xStream.aliasField("used-default-credentials", PrivateServerCfgInfo.class, "useDefaultCredentials");
        xStream.aliasField("basic-password", PrivateServerCfgInfo.class, "basicPassword");
        xStream.aliasField("basic-username", PrivateServerCfgInfo.class, "basicUsername");
        xStream.aliasField("use-http-basic", PrivateServerCfgInfo.class, "useHttpBasic");
        xStream.registerLocalConverter(PrivateServerCfgInfo.class, "password", (Converter)new EncodedStringConverter());
        xStream.registerLocalConverter(PrivateServerCfgInfo.class, "basicPassword", (Converter)new EncodedStringConverter());
        xStream.alias("private-project-cfg", PrivateProjectConfiguration.class);
        xStream.aliasField("private-server-cfgs", PrivateProjectConfiguration.class, "privateServerCfgInfos");
        xStream.aliasField("plans", PrivateProjectConfiguration.class, "plans");
        xStream.aliasField("useFavourites", PrivateProjectConfiguration.class, "use-favourites");
        xStream.aliasField("showBranches", PrivateProjectConfiguration.class, "show-branches");
        xStream.aliasField("myBranchesOnly", PrivateProjectConfiguration.class, "my-branches-only");
        xStream.aliasField("plans", BambooServerCfg.class, "plans");
        xStream.registerLocalConverter(ServerCfg.class, "password", (Converter)new EncodedStringConverter());
        xStream.alias("shared-server-list", SharedServerList.class);
        xStream.addDefaultImplementation(ArrayList.class, Collection.class);
        xStream.registerConverter(new Converter(){

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                SubscribedPlan value = (SubscribedPlan)source;
                writer.addAttribute(JDomXStreamUtil.PLAN_KEY, value.getKey());
                writer.addAttribute(JDomXStreamUtil.GROUPED_KEY, value.isGrouped() ? "1" : "0");
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return new SubscribedPlan(reader.getAttribute(JDomXStreamUtil.PLAN_KEY), "1".equals(reader.getAttribute(JDomXStreamUtil.GROUPED_KEY)));
            }

            public boolean canConvert(Class aClass) {
                return SubscribedPlan.class.isAssignableFrom(aClass);
            }
        });
        xStream.registerConverter(new Converter(){

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                ServerIdImpl value = (ServerIdImpl)source;
                writer.setValue(value.getId());
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return new ServerIdImpl(reader.getValue());
            }

            public boolean canConvert(Class type) {
                return type.equals(ServerIdImpl.class);
            }
        });
        return xStream;
    }
}

