/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;
import org.w3c.dom.Node;

public class CreateCommand
extends AbstractTextCommand {
    private StructuredActivity parent;
    private Activity child;
    private IDOMElement parentElement;
    private IDOMElement childElement;
    private int index = -1;
    private Rectangle bounds = null;
    private final EditPartViewer viewer;

    public CreateCommand(ITextEditor textEditor, EditPartViewer viewer) {
        super(textEditor);
        this.viewer = viewer;
    }

    public boolean canExecute() {
        this.parentElement = this.parent.getInput();
        this.childElement = this.child.getInput();
        if (this.parentElement == null || this.childElement == null) {
            return false;
        }
        Node ancestor = ((NodeImpl)this.parentElement).getCommonAncestor((Node)this.childElement);
        if (ancestor != null && ancestor.equals(this.childElement)) {
            return false;
        }
        List children = this.processor.getChildNames(this.parentElement);
        return children.contains(this.childElement.getNodeName());
    }

    public void execute() {
        Object part;
        if (this.index > 0) {
            this.parent.addChild(this.child, this.index);
        } else {
            this.parent.addChild(this.child);
        }
        if (this.bounds != null) {
            this.child.modifyBounds(this.bounds);
        }
        if ((part = this.viewer.getEditPartRegistry().get(this.child)) instanceof EditPart) {
            this.viewer.flush();
            this.viewer.reveal((EditPart)part);
            this.viewer.select((EditPart)part);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setChild(Activity activity) {
        this.child = activity;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setParent(StructuredActivity sa) {
        this.parent = sa;
    }
}

