/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.internal.plugins;

import java.util.ArrayList;
import java.util.List;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.plugins.PluginVersion;

public class Plugin {
    private List<PluginVersion> versions = new ArrayList<PluginVersion>();
    private PluginVersion latestVersion;
    private String name;
    private boolean isInplace = false;

    public Plugin(String name) {
        this.name = name;
    }

    public List<PluginVersion> getVersions() {
        return new ArrayList<PluginVersion>(this.versions);
    }

    public boolean addVersion(PluginVersion version) {
        if (version != null && !this.versions.contains(version) && this.getName().equals(version.getName())) {
            this.versions.add(version);
            version.setParent(this);
            return true;
        }
        return false;
    }

    public void removeVersion(PluginVersion version) {
        this.versions.remove(version);
    }

    public PluginVersion getVersion(String versionID) {
        if (versionID == null) {
            return null;
        }
        for (PluginVersion version : this.getVersions()) {
            if (!versionID.equals(version.getVersion())) continue;
            return version;
        }
        return null;
    }

    public boolean isInPlace() {
        return this.isInplace;
    }

    public void setIsInPlace(boolean isInplace) {
        this.isInplace = isInplace;
    }

    public boolean isInstalled() {
        return this.getInstalled() != null;
    }

    public PluginVersion getInstalled() {
        for (PluginVersion version : this.getVersions()) {
            if (!version.isInstalled()) continue;
            return version;
        }
        return null;
    }

    public boolean setLatestReleasedVersion(PluginVersion latestVersion) {
        if (this.versions.contains(latestVersion) || this.addVersion(latestVersion)) {
            this.latestVersion = latestVersion;
            this.latestVersion.setParent(this);
            return true;
        }
        return false;
    }

    public PluginVersion getMostRecentVersionAdded() {
        List<PluginVersion> children = this.getVersions();
        if (children != null && !children.isEmpty()) {
            return children.get(children.size() - 1);
        }
        return null;
    }

    public PluginVersion getLatestReleasedVersion() {
        return this.latestVersion;
    }

    public boolean isVersion(PluginVersion pluginToCheck) {
        if (pluginToCheck == null) {
            return false;
        }
        String nameToCheck = pluginToCheck.getName();
        String versionToCheck = pluginToCheck.getVersion();
        List<PluginVersion> versions = this.getVersions();
        if (versions != null && versionToCheck != null && nameToCheck != null && nameToCheck.equals(this.getName())) {
            for (PluginVersion ver : versions) {
                if (!versionToCheck.equals(ver.getVersion())) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasUpdate() {
        PluginVersion latestVersion = this.getLatestReleasedVersion();
        PluginVersion installedVersion = this.getInstalled();
        if (installedVersion == null) {
            return false;
        }
        return Plugin.isVersionHigher(latestVersion, installedVersion);
    }

    public static boolean isVersionHigher(PluginVersion data1, PluginVersion data2) {
        String version1 = data1.getVersion();
        String version2 = data2.getVersion();
        if (version1 != null && version2 != null) {
            return version1.compareToIgnoreCase(version2) > 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.isInplace) {
            sb.append(" (in-place)");
        }
        return sb.toString();
    }
}

