/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommand;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommandDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterFactory;

public class FrameworkCommand
implements IFrameworkCommand {
    private IFrameworkCommandDescriptor descriptor;
    private List<ICommandParameter> parameters;

    public FrameworkCommand(IFrameworkCommandDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public List<ICommandParameter> getParameters() {
        if (this.parameters == null) {
            ICommandParameterDescriptor[] parameterDescriptors;
            this.parameters = new ArrayList<ICommandParameter>();
            ICommandParameterDescriptor[] iCommandParameterDescriptorArray = parameterDescriptors = this.descriptor.getParameters();
            int n = parameterDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ICommandParameter parameter;
                ICommandParameterDescriptor paramDescriptor = iCommandParameterDescriptorArray[n2];
                if (paramDescriptor != null && (parameter = this.getCommandParameter(paramDescriptor)) != null) {
                    this.parameters.add(parameter);
                }
                ++n2;
            }
        }
        return this.parameters;
    }

    protected ICommandParameter getCommandParameter(ICommandParameterDescriptor descriptor) {
        return ParameterFactory.getParameterInstance(descriptor);
    }

    @Override
    public IFrameworkCommandDescriptor getCommandDescriptor() {
        return this.descriptor;
    }
}

