/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CompositeParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterFactory;

public class CompositeCommandParameter
extends CommandParameter {
    private List<ICommandParameter> parameters;

    public CompositeCommandParameter(CompositeParameterDescriptor descriptor) {
        super(descriptor);
    }

    public List<ICommandParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ICommandParameter>();
            CompositeParameterDescriptor descriptor = (CompositeParameterDescriptor)this.getParameterDescriptor();
            List<ICommandParameterDescriptor> childDescriptors = descriptor.getParameterDescriptors();
            for (ICommandParameterDescriptor child : childDescriptors) {
                ICommandParameter parameter = ParameterFactory.getParameterInstance(child);
                if (parameter == null) continue;
                this.parameters.add(parameter);
            }
        }
        return this.parameters;
    }

    @Override
    public Object getValue() {
        ICommandParameter setChildParameter = this.getSetChildCommandParameter();
        if (setChildParameter != null) {
            return setChildParameter.getValue();
        }
        return null;
    }

    @Override
    public boolean hasValue() {
        return this.getValue() != null;
    }

    public ICommandParameter getSetChildCommandParameter() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return null;
        }
        for (ICommandParameter parameter : this.parameters) {
            if (!parameter.hasValue()) continue;
            return parameter;
        }
        return null;
    }
}

