/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;

public class MavenClasspathUpdateJob
extends WorkspaceJob {
    private static final Queue<IJavaProject> SCHEDULED_PROJECTS = new ConcurrentLinkedQueue<IJavaProject>();
    private final IJavaProject javaProject;

    private MavenClasspathUpdateJob(IJavaProject javaProject) {
        super("Updating Maven dependencies for project '" + javaProject.getElementName() + "'");
        this.javaProject = javaProject;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.javaProject.getProject().isOpen() || monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            IContainer basedir = this.findPomXmlBasedir((IContainer)this.javaProject.getProject());
            if (basedir == null) {
                return Status.CANCEL_STATUS;
            }
            ILaunchConfiguration configuration = this.createLaunchConfiguration(basedir, "eclipse:clean eclipse:eclipse");
            if (configuration != null) {
                ILaunch launch = configuration.launch("run", (IProgressMonitor)new SubProgressMonitor(monitor, 75));
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new MavenProcessListener(launch.getProcesses()[0], this.javaProject.getProject()));
            }
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        return new Status(0, "org.springframework.ide.eclipse.maven", "Updated Maven dependencies");
    }

    /*
     * Exception decompiling
     */
    private IContainer findPomXmlBasedir(IContainer dir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ILaunchConfiguration createLaunchConfiguration(IContainer basedir, String goal) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(basedir, "Updating Maven dependencies for '" + basedir.getName() + "'");
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getLocation().toOSString());
            workingCopy.setAttribute("M2_GOALS", goal);
            workingCopy.setAttribute("M2_WORKSPACE_RESOLUTION", true);
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_SCOPE, "${project}");
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_RECURSIVE, true);
            String vmArguments = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            vmArguments = String.valueOf(vmArguments) + "-Declipse.workspace=\"${workspace_loc}\"";
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
            IPath path = this.getJREContainerPath(basedir);
            if (path != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path.toPortableString());
            }
            return workingCopy;
        }
        catch (CoreException ex) {
            MavenCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.maven", "Error occured", (Throwable)ex));
            return null;
        }
    }

    private IPath getJREContainerPath(IContainer basedir) throws CoreException {
        IProject project = basedir.getProject();
        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return entry.getPath();
                }
                ++i;
            }
        }
        return null;
    }

    public static void scheduleClasspathContainerUpdateJob(IJavaProject javaProject) {
        if (javaProject != null && !SCHEDULED_PROJECTS.contains(javaProject)) {
            MavenClasspathUpdateJob.newClasspathContainerUpdateJob(javaProject);
        }
    }

    public static void scheduleClasspathContainerUpdateJob(IProject oroject) {
        MavenClasspathUpdateJob.scheduleClasspathContainerUpdateJob(JavaCore.create((IProject)oroject));
    }

    private static MavenClasspathUpdateJob newClasspathContainerUpdateJob(IJavaProject javaProject) {
        MavenClasspathUpdateJob job = new MavenClasspathUpdateJob(javaProject);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.setPriority(40);
        job.addJobChangeListener(new DuplicateJobListener());
        job.schedule();
        return job;
    }

    private static class DuplicateJobListener
    extends JobChangeAdapter
    implements IJobChangeListener {
        private DuplicateJobListener() {
        }

        public void done(IJobChangeEvent event) {
            SCHEDULED_PROJECTS.remove(((MavenClasspathUpdateJob)event.getJob()).getJavaProject());
        }

        public void scheduled(IJobChangeEvent event) {
            SCHEDULED_PROJECTS.add(((MavenClasspathUpdateJob)event.getJob()).getJavaProject());
        }
    }

    private class MavenProcessListener
    implements IDebugEventSetListener {
        private final IProject project;
        private final IProcess newProcess;

        public MavenProcessListener(IProcess process, IProject project) {
            this.project = project;
            this.newProcess = process;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (events != null && this.project != null) {
                int size = events.length;
                int i = 0;
                while (i < size) {
                    if (this.newProcess != null && this.newProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        Job job = new Job("refresh project"){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    MavenProcessListener.this.project.refreshLocal(2, monitor);
                                }
                                catch (CoreException coreException) {}
                                return Status.OK_STATUS;
                            }
                        };
                        job.setSystem(true);
                        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                        job.setPriority(10);
                        job.schedule();
                    }
                    ++i;
                }
            }
        }
    }
}

