/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven;

import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public abstract class AbstractSpringProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    public final void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (request != null) {
            MavenProject mavenProject = request.getMavenProject();
            IProject project = request.getProject();
            this.doConfigure(mavenProject, project, request, monitor);
        }
    }

    public void configureClasspath(IMavenProjectFacade arg0, IClasspathDescriptor arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void configureRawClasspath(ProjectConfigurationRequest arg0, IClasspathDescriptor arg1, IProgressMonitor arg2) throws CoreException {
    }

    private Plugin getEclipsePlugin(MavenProject mavenProject) {
        return mavenProject.getPlugin("org.apache.maven.plugins:maven-eclipse-plugin");
    }

    protected boolean configureNature(IProject project, MavenProject mavenProject, String natureId, boolean addNature, INatureCallback callback, IProgressMonitor monitor) throws CoreException {
        if (this.hasProjectNature(mavenProject, project, natureId)) {
            if (!SpringCoreUtils.hasNature((IResource)project, (String)natureId) && addNature) {
                if (callback != null) {
                    callback.beforeAddingNature();
                }
                SpringCoreUtils.addProjectNature((IProject)project, (String)natureId, (IProgressMonitor)monitor);
                if (callback != null) {
                    callback.afterAddingNature();
                }
            }
            return true;
        }
        SpringCoreUtils.removeProjectNature((IProject)project, (String)natureId, (IProgressMonitor)monitor);
        return false;
    }

    protected boolean configureNature(IProject project, MavenProject mavenProject, String natureId, boolean addNature, IProgressMonitor monitor) throws CoreException {
        return this.configureNature(project, mavenProject, natureId, addNature, null, monitor);
    }

    protected abstract void doConfigure(MavenProject var1, IProject var2, ProjectConfigurationRequest var3, IProgressMonitor var4) throws CoreException;

    protected boolean hasProjectNature(MavenProject mavenProject, IProject project, String natureId) {
        Xpp3Dom additionalBuildCommands;
        Xpp3Dom configuration;
        Plugin plugin = this.getEclipsePlugin(mavenProject);
        if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null && (additionalBuildCommands = configuration.getChild("additionalProjectnatures")) != null) {
            Xpp3Dom[] xpp3DomArray = additionalBuildCommands.getChildren("projectnature");
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom projectNature = xpp3DomArray[n2];
                if (projectNature != null && natureId.equals(projectNature.getValue())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static interface INatureCallback {
        public void beforeAddingNature();

        public void afterAddingNature();
    }

    public class NatureCallbackAdapter
    implements INatureCallback {
        @Override
        public void beforeAddingNature() {
        }

        @Override
        public void afterAddingNature() {
        }
    }
}

