/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AspectJAdviceClassFactory;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AspectDefinitionMatcher {
    private Map<IAspectDefinition, Object> pointcutExpressionCache = new HashMap<IAspectDefinition, Object>();

    public Set<IMethod> matches(Class<?> targetClass, IBean targetBean, IAspectDefinition info, IProject project) throws Throwable {
        LinkedHashSet<IMethod> matches = new LinkedHashSet<IMethod>();
        if (SpringCoreUtils.hasPlaceHolder((String)info.getPointcutExpression())) {
            return Collections.emptySet();
        }
        Class proxyCreationContextClass = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass((String)"org.springframework.ide.eclipse.springframework.aop.framework.autoproxy.ProxyCreationContext");
        ArrayList<String> beanNames = new ArrayList<String>();
        beanNames.add(targetBean.getElementName());
        if (targetBean.getAliases() != null && targetBean.getAliases().length > 0) {
            beanNames.addAll(Arrays.asList(targetBean.getAliases()));
        }
        for (String beanName : beanNames) {
            org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod((Object)proxyCreationContextClass, (String)"setCurrentProxiedBeanName", (Object[])new Object[]{beanName}, (Class[])new Class[]{String.class});
            try {
                matches.addAll(this.internalMatches(targetClass, targetBean, info, project));
            }
            catch (Throwable throwable) {
                org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod((Object)proxyCreationContextClass, (String)"setCurrentProxiedBeanName", (Object[])new Object[1], (Class[])new Class[]{String.class});
                throw throwable;
            }
            org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod((Object)proxyCreationContextClass, (String)"setCurrentProxiedBeanName", (Object[])new Object[1], (Class[])new Class[]{String.class});
        }
        return matches;
    }

    public void close() {
        for (Object pce : this.pointcutExpressionCache.values()) {
            Field field = ReflectionUtils.findField(pce.getClass(), (String)"shadowMatchCache");
            field.setAccessible(true);
            Map shadowMatchCache = (Map)ReflectionUtils.getField((Field)field, (Object)pce);
            try {
                Class<?> resolvedTypeClass = pce.getClass().getClassLoader().loadClass("org.aspectj.weaver.ResolvedType");
                Method resetPrimitivesMethod = resolvedTypeClass.getMethod("resetPrimitives", new Class[0]);
                resetPrimitivesMethod.invoke(resolvedTypeClass, new Object[0]);
            }
            catch (Exception exception) {}
            shadowMatchCache.clear();
        }
        this.pointcutExpressionCache.clear();
    }

    private boolean checkMethod(Class targetClass, Method targetMethod, boolean isProxyTargetClass) {
        Assert.notNull((Object)targetClass);
        Assert.notNull((Object)targetMethod);
        if (!Modifier.isPublic(targetMethod.getModifiers())) {
            return false;
        }
        if (isProxyTargetClass) {
            return true;
        }
        Class[] targetInterfaces = ClassUtils.getAllInterfacesForClass((Class)targetClass);
        if (targetInterfaces == null || targetInterfaces.length == 0) {
            return true;
        }
        Class[] classArray = targetInterfaces;
        int n = targetInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] targetInterfaceMethods;
            Class targetInterface = classArray[n2];
            Method[] methodArray = targetInterfaceMethods = targetInterface.getMethods();
            int n3 = targetInterfaceMethods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method targetInterfaceMethod = methodArray[n4];
                Method targetMethodGuess = AopUtils.getMostSpecificMethod((Method)targetInterfaceMethod, (Class)targetClass);
                if (targetMethod.equals(targetMethodGuess)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkClass(Class targetClass, boolean isProxyTargetClass) throws ClassNotFoundException {
        if (this.isInfrastructureClass(targetClass)) {
            return false;
        }
        return !Modifier.isFinal(targetClass.getModifiers()) || !isProxyTargetClass;
    }

    private Object createAspectJPointcutExpression(IAspectDefinition info) throws Throwable {
        try {
            if (this.pointcutExpressionCache.containsKey(info)) {
                return this.pointcutExpressionCache.get(info);
            }
            Object pc = this.initAspectJExpressionPointcut(info);
            this.pointcutExpressionCache.put(info, pc);
            Class<?> aspectJAdviceClass = AspectJAdviceClassFactory.getAspectJAdviceClass(info);
            Class aspectInstanceFactoryClass = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass((String)"org.springframework.ide.eclipse.springframework.aop.aspectj.SimpleAspectInstanceFactory");
            if (aspectJAdviceClass != null && aspectInstanceFactoryClass != null) {
                Constructor<?> ctor = aspectInstanceFactoryClass.getConstructors()[0];
                Object aspectInstanceFactory = ctor.newInstance(aspectJAdviceClass);
                ctor = aspectJAdviceClass.getConstructors()[0];
                Object aspectJAdvice = ctor.newInstance(info.getAdviceMethod(), pc, aspectInstanceFactory);
                if (info.getType() == IAopReference.ADVICE_TYPE.AFTER_RETURNING) {
                    if (info.getReturning() != null) {
                        org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod(aspectJAdvice, (String)"setReturningName", (Object[])new Object[]{info.getReturning()});
                    }
                } else if (info.getType() == IAopReference.ADVICE_TYPE.AFTER_THROWING && info.getThrowing() != null) {
                    org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod(aspectJAdvice, (String)"setThrowingName", (Object[])new Object[]{info.getThrowing()});
                }
                if (info.getArgNames() != null && info.getArgNames().length > 0) {
                    org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod(aspectJAdvice, (String)"setArgumentNamesFromStringArray", (Object[])new Object[]{info.getArgNames()});
                }
                return org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod(aspectJAdvice, (String)"getPointcut", (Object[])new Object[0]);
            }
            return pc;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Object initAspectJExpressionPointcut(IAspectDefinition info) throws Throwable {
        Class expressionPointcutClass = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass((String)"org.springframework.ide.eclipse.springframework.aop.aspectj.AspectJExpressionPointcut");
        Object pc = expressionPointcutClass.newInstance();
        Method[] methodArray = expressionPointcutClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals("setExpression")) {
                m.invoke(pc, info.getPointcutExpression());
            }
            ++n2;
        }
        if (info.getAspectClassName() != null) {
            org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod(pc, (String)"setPointcutDeclarationScope", (Object[])new Object[]{org.springframework.ide.eclipse.core.java.ClassUtils.loadClass((String)info.getAspectClassName())});
        }
        return pc;
    }

    private Set<IMethod> internalMatches(final Class<?> targetClass, IBean targetBean, final IAspectDefinition info, IProject project) throws Throwable {
        if (!this.checkClass(targetClass, info.isProxyTargetClass())) {
            return Collections.emptySet();
        }
        BeanDefinition beanDefinition = BeansModelUtils.getMergedBeanDefinition((IBean)targetBean, null);
        if (beanDefinition instanceof RootBeanDefinition && ((RootBeanDefinition)beanDefinition).isSynthetic()) {
            return Collections.emptySet();
        }
        if (info.getPointcutExpression() == null) {
            return Collections.emptySet();
        }
        final HashSet<IMethod> matchingMethods = new HashSet<IMethod>();
        final Object aspectJExpressionPointcut = this.createAspectJPointcutExpression(info);
        if (!((Boolean)org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod((Object)aspectJExpressionPointcut, (String)"matches", (Object[])new Object[]{targetClass})).booleanValue()) {
            return matchingMethods;
        }
        final IType jdtTargetType = JdtUtils.getJavaType((IProject)project, (String)targetClass.getName());
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (AspectDefinitionMatcher.this.checkMethod(targetClass, method, info.isProxyTargetClass()) && !matchingMethods.contains(method)) {
                    try {
                        Class[] targetInterfaces;
                        boolean matches = (Boolean)org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod((Object)aspectJExpressionPointcut, (String)"matches", (Object[])new Object[]{method, targetClass});
                        if (matches) {
                            this.addMatchingJdtMethod(matchingMethods, jdtTargetType, method);
                        } else if (!info.isProxyTargetClass() && (targetInterfaces = ClassUtils.getAllInterfacesForClass((Class)targetClass)) != null) {
                            Class[] classArray = targetInterfaces;
                            int n = targetInterfaces.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Method[] targetInterfaceMethods;
                                Class targetInterface = classArray[n2];
                                Method[] methodArray = targetInterfaceMethods = targetInterface.getMethods();
                                int n3 = targetInterfaceMethods.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Method targetInterfaceMethod = methodArray[n4];
                                    Method targetMethodGuess = AopUtils.getMostSpecificMethod((Method)targetInterfaceMethod, (Class)targetClass);
                                    if (method.equals(targetMethodGuess) && (matches = ((Boolean)org.springframework.ide.eclipse.core.java.ClassUtils.invokeMethod((Object)aspectJExpressionPointcut, (String)"matches", (Object[])new Object[]{targetInterfaceMethod, targetInterface})).booleanValue())) {
                                        this.addMatchingJdtMethod(matchingMethods, jdtTargetType, method);
                                    }
                                    ++n4;
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof IllegalArgumentException) {
                            throw (IllegalArgumentException)e;
                        }
                        if (e instanceof IllegalAccessException) {
                            throw (IllegalAccessException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }
            }

            private void addMatchingJdtMethod(Set<IMethod> matchingMethods2, IType jdtTargetType2, Method method) {
                IMethod jdtMethod = JdtUtils.getMethod((IType)jdtTargetType2, (String)method.getName(), (Class[])method.getParameterTypes());
                if (jdtMethod != null) {
                    matchingMethods2.add(jdtMethod);
                }
            }
        });
        return matchingMethods;
    }

    private boolean isInfrastructureClass(Class<?> beanClass) throws ClassNotFoundException {
        Class advisorClass = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass(Advisor.class);
        Class adviceClass = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass(Advice.class);
        Class aopInfrastructureBeanClass = org.springframework.ide.eclipse.core.java.ClassUtils.loadClass(AopInfrastructureBean.class);
        return advisorClass.isAssignableFrom(beanClass) || adviceClass.isAssignableFrom(beanClass) || aopInfrastructureBeanClass.isAssignableFrom(beanClass);
    }
}

