/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.aop.core.internal.model.AopProject;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReferenceModelPeristence;
import org.springframework.ide.eclipse.aop.core.internal.model.AopResourceChangeEvents;
import org.springframework.ide.eclipse.aop.core.model.IAopModelChangedListener;
import org.springframework.ide.eclipse.aop.core.model.IAopProject;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAopReferenceModel;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.internal.model.resources.ISpringResourceChangeEvents;
import org.springframework.ide.eclipse.core.internal.model.resources.SpringResourceChangeListener;

public class AopReferenceModel
implements IAopReferenceModel {
    private List<IAopModelChangedListener> listeners = new LinkedList<IAopModelChangedListener>();
    private AopReferenceModelPeristence persistence;
    private Map<IJavaProject, IAopProject> projects = new ConcurrentHashMap<IJavaProject, IAopProject>();
    private IResourceChangeListener workspaceListener;

    @Override
    public void addProject(IJavaProject project, IAopProject aopProject) {
        this.projects.put(project, aopProject);
    }

    @Override
    public void fireModelChanged() {
        for (IAopModelChangedListener listener : this.listeners) {
            listener.changed();
        }
    }

    @Override
    public List<IAopReference> getAdviceDefinition(IJavaElement je) {
        LinkedList<IAopReference> advices = new LinkedList<IAopReference>();
        for (IAopReference reference : this.getAllReferences()) {
            if (reference.getSource() == null || !reference.getSource().equals(je)) continue;
            advices.add(reference);
        }
        return advices;
    }

    @Override
    public List<IAopReference> getAllReferences() {
        ArrayList<IAopReference> refs = new ArrayList<IAopReference>();
        for (Map.Entry<IJavaProject, IAopProject> e : this.projects.entrySet()) {
            refs.addAll(e.getValue().getAllReferences());
        }
        return refs;
    }

    @Override
    public List<IAopReference> getAllReferencesForResource(IResource resource) {
        ArrayList<IAopReference> references = new ArrayList<IAopReference>();
        for (IAopReference ref : this.getAllReferences()) {
            if (!(ref.getResource() != null && ref.getResource().equals((Object)resource) || AopReferenceModelUtils.getBeanFromElementId(ref.getTargetBeanId()) != null && resource.equals((Object)AopReferenceModelUtils.getBeanFromElementId(ref.getTargetBeanId()).getElementResource()) || ref.getSource() != null && resource.equals((Object)ref.getSource().getResource()) || ref.getTarget() != null && resource.equals((Object)ref.getTarget().getResource())) && !ref.getDefinition().getResource().equals((Object)resource)) continue;
            references.add(ref);
        }
        return references;
    }

    @Override
    public IAopProject getProject(IJavaProject project) {
        return this.getProjectWithInitialization(project);
    }

    @Override
    public Collection<IAopProject> getProjects() {
        return this.projects.values();
    }

    public IAopProject getProjectWithInitialization(IJavaProject project) {
        if (this.projects.containsKey(project)) {
            return this.projects.get(project);
        }
        AopProject aopProject = new AopProject(project);
        this.addProject(project, aopProject);
        return aopProject;
    }

    @Override
    public boolean isAdvice(IJavaElement je) {
        return this.getAdviceDefinition(je).size() > 0;
    }

    @Override
    public boolean isAdvised(IJavaElement je) {
        if (je != null) {
            List<IAopReference> references = this.getAllReferences();
            for (IAopReference reference : references) {
                if (!reference.getTarget().equals(je)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAdvised(IBean bean) {
        if (bean != null) {
            String beanId = bean.getElementID();
            List<IAopReference> references = this.getAllReferences();
            for (IAopReference reference : references) {
                if (!reference.getTargetBeanId().equals(beanId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void registerAopModelChangedListener(IAopModelChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeProject(IJavaProject project) {
        for (IJavaProject jp : this.projects.keySet()) {
            if (!jp.equals(project)) continue;
            this.projects.remove(jp);
            this.fireModelChanged();
            break;
        }
    }

    @Override
    public synchronized void clearProjects() {
        this.projects.clear();
    }

    @Override
    public void shutdown() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.workspaceListener);
        this.workspaceListener = null;
        this.persistence.saveReferenceModel();
        this.projects.clear();
    }

    @Override
    public void start() {
        this.workspaceListener = new SpringResourceChangeListener((ISpringResourceChangeEvents)new AopResourceChangeEvents());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.workspaceListener, 62);
        this.persistence = new AopReferenceModelPeristence();
        this.persistence.loadReferenceModel();
    }

    @Override
    public void unregisterAopModelChangedListener(IAopModelChangedListener listener) {
        this.listeners.remove(listener);
    }
}

