/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.EndState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.OutputMapperComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class EndStatePropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IEndState endState;
    private IEndState endStateClone;
    private Label nameLabel;
    private Text nameText;
    private Label viewLabel;
    private Text viewText;
    private Button okButton;
    private IWebflowModelElement parent;
    private PropertiesComposite properties;
    private ActionComposite entryActionsComposite;
    private OutputMapperComposite outputMapperComposite;
    private ExceptionHandlerComposite exceptionHandlerComposite;
    private List<IActionElement> entryActions;
    private List<IOutputAttribute> outputAttributes;
    private List<IMapping> outputMapping;
    private List<IExceptionHandler> exceptionHandler;
    private Label parentLabel;
    private Text parentText;
    private Label commitLabel;
    private Button commitText;

    public EndStatePropertiesDialog(Shell parentShell, IWebflowModelElement parent, IEndState state) {
        super(parentShell);
        EntryActions entry;
        this.endState = state;
        this.parent = parent;
        this.endStateClone = ((EndState)state).cloneModelElement();
        if (this.endStateClone.getEntryActions() != null) {
            this.entryActions = new ArrayList<IActionElement>();
            this.entryActions.addAll(this.endStateClone.getEntryActions().getEntryActions());
        } else {
            this.entryActions = new ArrayList<IActionElement>();
            entry = new EntryActions();
            entry.createNew((IWebflowModelElement)this.endStateClone);
            this.endStateClone.setEntryActions((IEntryActions)entry);
        }
        if (this.endStateClone.getOutputMapper() != null) {
            this.outputAttributes = new ArrayList<IOutputAttribute>();
            this.outputMapping = new ArrayList<IMapping>();
            this.outputAttributes.addAll(this.endStateClone.getOutputMapper().getOutputAttributes());
            this.outputMapping.addAll(this.endStateClone.getOutputMapper().getMapping());
        } else {
            this.outputAttributes = new ArrayList<IOutputAttribute>();
            this.outputMapping = new ArrayList<IMapping>();
            entry = new OutputMapper();
            entry.createNew((IWebflowModelElement)this.endStateClone);
            this.endStateClone.setOutputMapper((IOutputMapper)entry);
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        if (this.endStateClone.getExceptionHandlers() != null) {
            this.exceptionHandler.addAll(this.endStateClone.getExceptionHandlers());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.endStateClone.setId(this.trimString(this.getId()));
            this.endStateClone.setView(this.trimString(this.viewText.getText()));
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.endState)) {
                this.endStateClone.setParent(this.trimString(this.parentText.getText()));
                this.endStateClone.setCommit(Boolean.toString(this.commitText.getSelection()));
            }
            if (this.endState.getEntryActions() == null && this.entryActions.size() > 0) {
                EntryActions entryActions = new EntryActions();
                entryActions.createNew((IWebflowModelElement)this.endStateClone);
                for (IActionElement iActionElement : this.entryActions) {
                    entryActions.addEntryAction(iActionElement);
                }
                this.endStateClone.setEntryActions((IEntryActions)entryActions);
            } else if (this.entryActions.size() == 0) {
                this.endStateClone.setEntryActions(null);
            } else {
                this.endStateClone.getEntryActions().removeAll();
                for (IActionElement iActionElement : this.entryActions) {
                    this.endStateClone.getEntryActions().addEntryAction(iActionElement);
                }
            }
            if (this.exceptionHandler != null && this.exceptionHandler.size() > 0) {
                this.endStateClone.removeAllExceptionHandler();
                for (IExceptionHandler iExceptionHandler : this.exceptionHandler) {
                    this.endStateClone.addExceptionHandler(iExceptionHandler);
                }
            } else {
                this.endStateClone.removeAllExceptionHandler();
            }
            if (this.endState.getOutputMapper() == null && (this.outputAttributes.size() > 0 || this.outputMapping.size() > 0)) {
                OutputMapper outputMapper = new OutputMapper();
                outputMapper.createNew((IWebflowModelElement)this.endStateClone);
                for (IInputAttribute iInputAttribute : this.outputAttributes) {
                    outputMapper.addOutputAttribute((IOutputAttribute)iInputAttribute);
                }
                for (IMapping iMapping : this.outputMapping) {
                    outputMapper.addMapping(iMapping);
                }
                this.endStateClone.setOutputMapper((IOutputMapper)outputMapper);
            } else if (this.outputAttributes.size() == 0 && this.outputMapping.size() == 0) {
                this.endStateClone.setOutputMapper(null);
            } else {
                this.endStateClone.getOutputMapper().removeAllOutputAttribute();
                this.endStateClone.getOutputMapper().removeAllMapping();
                for (IInputAttribute iInputAttribute : this.outputAttributes) {
                    this.endStateClone.getOutputMapper().addOutputAttribute((IOutputAttribute)iInputAttribute);
                }
                for (IMapping iMapping : this.outputMapping) {
                    this.endStateClone.getOutputMapper().addMapping(iMapping);
                }
            }
            ((ICloneableModelElement)this.endState).applyCloneValues((IWebflowModelElement)this.endStateClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.endState != null && this.endState.getId() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item3 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        TabItem item5 = new TabItem(folder, 0);
        TabItem item6 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" View State ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("State id");
        this.nameText = new Text(nameGroup, 2052);
        if (this.endState != null && this.endState.getId() != null) {
            this.nameText.setText(this.endState.getId());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EndStatePropertiesDialog.this.validateInput();
            }
        });
        this.viewLabel = new Label(nameGroup, 0);
        this.viewLabel.setText("View");
        this.viewText = new Text(nameGroup, 2052);
        if (this.endState != null && this.endState.getView() != null) {
            this.viewText.setText(this.endState.getView());
        }
        this.viewText.setLayoutData((Object)new GridData(768));
        this.viewText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EndStatePropertiesDialog.this.validateInput();
            }
        });
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.endState)) {
            this.parentLabel = new Label(nameGroup, 0);
            this.parentLabel.setText("Parent state id");
            this.parentText = new Text(nameGroup, 2052);
            if (this.endState != null && this.endState.getParent() != null) {
                this.parentText.setText(this.endState.getParent());
            }
            this.parentText.setLayoutData((Object)new GridData(768));
            this.parentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EndStatePropertiesDialog.this.validateInput();
                }
            });
            this.commitLabel = new Label(nameGroup, 0);
            this.commitLabel.setText("Commit");
            this.commitText = new Button(nameGroup, 2080);
            if (this.endState != null && this.endState.getCommit() != null && this.endState.getCommit().equalsIgnoreCase("true")) {
                this.commitText.setSelection(true);
            }
            this.commitText.setLayoutData((Object)new GridData(768));
        }
        item1.setControl((Control)groupActionType);
        this.entryActionsComposite = new ActionComposite(this, item3, this.getShell(), this.entryActions, (IWebflowModelElement)this.endStateClone.getEntryActions(), IActionElement.ACTION_TYPE.ENTRY_ACTION);
        item3.setControl(this.entryActionsComposite.createDialogArea((Composite)folder));
        this.outputMapperComposite = new OutputMapperComposite(this, item4, this.getShell(), this.outputAttributes, this.outputMapping, this.endStateClone.getOutputMapper());
        item4.setControl(this.outputMapperComposite.createDialogArea((Composite)folder));
        this.exceptionHandlerComposite = new ExceptionHandlerComposite(this, item5, this.getShell(), this.exceptionHandler, (IWebflowModelElement)this.endStateClone);
        item5.setControl(this.exceptionHandlerComposite.createDialogArea((Composite)folder));
        this.properties = new PropertiesComposite(this, item6, this.getShell(), (IAttributeEnabled)this.endStateClone);
        item6.setControl(this.properties.createDialogArea((Composite)folder));
        EndStatePropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.end_state_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the end state";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parent;
    }

    protected String getShellTitle() {
        return "End State";
    }

    protected String getTitle() {
        return "End State properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    @Override
    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid id attribute is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

