/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.util.StringUtils;

public class StateValidationRule
implements IValidationRule<IState, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof IState && !(element instanceof WebflowState) && context instanceof WebflowValidationContext;
    }

    public void validate(IState state, WebflowValidationContext context, IProgressMonitor monitor) {
        if (!StringUtils.hasText((String)state.getId())) {
            context.error(state, "NO_ID", "Element requires unique 'id' attribute", new ValidationProblemAttribute[0]);
        } else if (!WebflowModelUtils.isStateIdUnique(state)) {
            context.error(state, "NO_UNIQUE_ID_GIVEN", MessageUtils.format((String)"Specified state id \"{0}\" is not unique", (Object)state.getId()), new ValidationProblemAttribute[0]);
        }
    }
}

